% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{createInstrumentalTable}
\alias{createInstrumentalTable}
\title{Create Instrumental Table}
\usage{
createInstrumentalTable(files)
}
\arguments{
\item{files}{File paths to experiment samples.}
}
\description{
Create table containing instrumental information such as sample IDs and file names.
}
\details{
Creates instrumental information table based on experiment sample file paths. Columns containing further information can also be added to this.
}
\examples{
\dontrun{
library(gcspikelite)

files <- list.files(system.file('data',package = 'gcspikelite'),full.names = TRUE)
files <- files[sapply(files,grepl,pattern = 'CDF')]

instrumental <- createInstrumentalTable(files)
}
}
\seealso{
\code{\link{newExp}} \code{\link{createPhenoTable}}
}
