% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{finds_l2d}
\alias{finds_l2d}
\alias{finds_l2d.list}
\title{Convert Finds List Object to Data Frame (Context / Find-Type)}
\usage{
finds_l2d(input)

\method{finds_l2d}{list}(input)
}
\arguments{
\item{input}{A list object of finds (each one a list) of associated contexts and types.}
}
\value{
A three-column data frame of contexts (first column) and find-types attested in that context (second column), along with the id number (third column).
}
\description{
Performs the opposite of \code{\link[eratosthenes]{finds_d2l}}. Takes a \code{list} object of finds and their types, used as input in \code{\link[eratosthenes]{gibbs_ad}}, and returns a \code{data.frame} of two columns, containing the context in the first and the find-type in the second, and the \code{id} of the object in the third.
}
\examples{
f1 <- list(id = "find01", assoc = "D", type = c("type1", "form1"))
f2 <- list(id = "find02", assoc = "E", type = c("type1", "form2"))
f3 <- list(id = "find03", assoc = "G", type = c("type1", "form1"))
f4 <- list(id = "find04", assoc = "H", type = c("type2", "form1"))
f5 <- list(id = "find05", assoc = "I", type = "type2")
f6 <- list(id = "find06", assoc = "H", type = NULL)

artifacts <- list(f1, f2, f3, f4, f5, f6)

# convert list to data frame
artifacts_df <- finds_l2d(artifacts)

}
