% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{gibbs_ad_use}
\alias{gibbs_ad_use}
\alias{gibbs_ad_use.marginals}
\title{Gibbs Sampler for Archaeological Dates: Artifact Use}
\usage{
gibbs_ad_use(
  marginalized,
  finds,
  id = NULL,
  type = NULL,
  type_name = NULL,
  max_samples = 10^5,
  size = 10^3,
  mcse_crit = 0.5
)

\method{gibbs_ad_use}{marginals}(
  marginalized,
  finds,
  id = NULL,
  type = NULL,
  type_name = NULL,
  max_samples = 10^5,
  size = 10^3,
  mcse_crit = 0.5
)
}
\arguments{
\item{marginalized}{A \code{list} object of class \code{marginals}, the output of \code{\link[eratosthenes]{gibbs_ad}}.}

\item{finds}{Either the \code{list} object of finds used as input to produce \code{marginals} or a \code{data.frame} of two columns, the first listing the context and the second the incidence of the type in that context.}

\item{id}{A vector of the \code{id} of one or more specific finds whose use date is to be estimated. The values of \code{id} must match those in the \code{list} of \code{finds}. If \code{type} is used, \code{id} is ignored.}

\item{type}{A vector of one or more types to estimate a use density for. Must contain a value if \code{id} is \code{NULL}.}

\item{type_name}{A customized label for the type (e.g., if one is selecting via \code{id} or has combined subtypes). If only \code{type} is used to select finds, the default will be that label Otherwise the default is simply "Type."}

\item{max_samples}{Maximum number of samples to run. Default is \code{10^5}.}

\item{size}{The number of samples to take on each iteration of the main Gibbs sampler. Default is \code{10^3}.}

\item{mcse_crit}{Criterion for the Monte Carlo standard error to stop the Gibbs sampler. Only the MCSE of the use date is used as a stopping rule.}
}
\value{
A \code{list} of class \code{use_marginals} of the density of a use date, conditional upon production and depositional dates.
}
\description{
Using the results of \code{\link[eratosthenes]{gibbs_ad}}, estimate a single density for the date of use of an artifact or artifact type. Multiple artifacts and types can be given, which will be pooled into a single type. For example, one can input several individual finds via their id number as comprising a type, or multiple (sub)types/classes as a single type, (e.g., "MGS V amphora", "MGS VI amphora", "MGS V/VI amphora" to construct one group).
}
\details{
Depending on whether one is using id numbers or type(s), the \code{id} or \code{type} argument is used, which takes a vector of the entries' names. The \code{gibbs_ad_use} function samples a use date between the production and depositional densities from the results of \code{\link[eratosthenes]{gibbs_ad}}, and in turn pools those densities for the production and deposition of the stipulated ids/type; the resulting \code{list} object does \emph{not} express marginalized densities of production and deposition in light of the estimation of a use date.

See \code{\link[eratosthenes]{gibbs_ad}} for information on consistent batch means and Monte Carlo standard error, which are used to determined convergence for the use date.
}
\examples{
x <- c("A", "B", "C", "D", "E", "F", "G", "H", "I", "J")
y <- c("B", "D", "G", "H", "K")
z <- c("F", "K", "L", "M")
contexts <- list(x, y, z)

f1 <- list(id = "find01", assoc = "D", type = c("type1", "form1"))
f2 <- list(id = "find02", assoc = "E", type = c("type1", "form2"))
f3 <- list(id = "find03", assoc = "G", type = c("type1", "form1"))
f4 <- list(id = "find04", assoc = "H", type = c("type2", "form1"))
f5 <- list(id = "find05", assoc = "I", type = "type2")
f6 <- list(id = "find06", assoc = "H", type = NULL)

artifacts <- list(f1, f2, f3, f4, f5, f6)
 
# external constraints
coin1 <- list(id = "coin1", assoc = "B", type = NULL, samples = runif(100,-320,-300))
coin2 <- list(id = "coin2", assoc = "G", type = NULL, samples = seq(37, 41, length = 100))
destr <- list(id = "destr", assoc = "J", type = NULL, samples = 79)

tpq_info <- list(coin1, coin2)
taq_info <- list(destr)

result <- gibbs_ad(contexts, finds = artifacts, tpq = tpq_info, taq = taq_info)

# use dates by specifying ids
gibbs_ad_use(result, artifacts, id = c("find04", "find05"), max_samples = 2000, mcse_crit = 2)

# use dates by specifying types
gibbs_ad_use(result, artifacts, type = "type1", max_samples = 2000, mcse_crit = 2)

}
