% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{histogram}
\alias{histogram}
\alias{histogram.marginals}
\alias{histogram.use_marginals}
\title{Histogram of Marginal Densities}
\usage{
histogram(
  x,
  events = NULL,
  aspect = c("production", "use", "deposition"),
  display_name = "Type",
  breaks = "Freedman-Diaconis",
  xlim = NULL,
  ylim = NULL,
  xlab = "Year",
  palette = NULL,
  opacity = 1,
  legend_pos = "topright"
)

\method{histogram}{marginals}(
  x,
  events = NULL,
  aspect = NULL,
  display_name = NULL,
  breaks = "Freedman-Diaconis",
  xlim = NULL,
  ylim = NULL,
  xlab = "Year",
  palette = NULL,
  opacity = 1,
  legend_pos = "topright"
)

\method{histogram}{use_marginals}(
  x,
  events = NULL,
  aspect = c("production", "use", "deposition"),
  display_name = "Type",
  breaks = "Freedman-Diaconis",
  xlim = NULL,
  ylim = NULL,
  xlab = "Year",
  palette = NULL,
  opacity = 0.5,
  legend_pos = "topright"
)
}
\arguments{
\item{x}{A \code{list} object of class \code{marginals}, the output of \code{\link[eratosthenes]{gibbs_ad}}, or of class \code{use_marginals}, to plot the output of \code{\link[eratosthenes]{gibbs_ad_use}]}.}

\item{events}{If plotting a \code{marginals} object, a vector or element of the event names to plot. Maximum number of events is 12.}

\item{aspect}{If plotting a \code{use_marginals} object, that is, the output of \code{\link[eratosthenes]{gibbs_ad_use}}, a vector of one or more of \code{c("production", "use", "deposition")}. The default is all three.}

\item{display_name}{If plotting a \code{use_marginals} object, the name of the artifact type to display in the histogram legend. Default is \code{"Type"}.}

\item{breaks}{The number or method of breaks in the histogram. Default is \code{"Freedman-Diaconis"}. See \code{\link[graphics]{hist}} for more.}

\item{xlim}{The limits of the x-axis. Default is set to the min/max values of all samples.}

\item{ylim}{The limits of the y-axis. This may need to be adjusted if densities have an extremely narrow interval.}

\item{xlab}{Label for the x-axis. Default is \code{"Year"}.}

\item{palette}{A vector providing the color palette of the histogram. The default is \code{"colorBlindness::paletteMartin"} (see \code{\link[paletteer]{palettes_d}}).}

\item{opacity}{The opacity/transparency of the histograms for visualizing overlapping events, a value between 0 and 1 (default).}

\item{legend_pos}{The position of the legend in the plot. Default is \code{"topright"}.}
}
\value{
A density histogram of the selected events/aspects.

A density histogram of the selected events/aspect.
}
\description{
Wrapper around \code{\link[graphics]{hist}} to plot density histograms for select marginal densities (up to 12) in a single plot, from the results of \code{\link[eratosthenes]{gibbs_ad}}, or to plot density histograms of the production, deposition, and use of a type, from the results of \code{\link[eratosthenes]{gibbs_ad_use}]}.
}
\details{
Also see also \code{\link[eratosthenes]{tidy_marginals}} for exporting the results of these functions into tidy data frame for custom plotting in e.g., \code{ggplot2}.
}
\examples{
x <- c("A", "B", "C", "D", "E", "F", "G", "H", "I", "J")
y <- c("B", "D", "G", "H", "K")
z <- c("F", "K", "L", "M")
contexts <- list(x, y, z)

f1 <- list(id = "find01", assoc = "D", type = c("type1", "form1"))
f2 <- list(id = "find02", assoc = "E", type = c("type1", "form2"))
f3 <- list(id = "find03", assoc = "G", type = c("type1", "form1"))
f4 <- list(id = "find04", assoc = "H", type = c("type2", "form1"))
f5 <- list(id = "find05", assoc = "I", type = "type2")
f6 <- list(id = "find06", assoc = "H", type = NULL)

artifacts <- list(f1, f2, f3, f4, f5, f6)
 
# external constraints
coin1 <- list(id = "coin1", assoc = "B", type = NULL, samples = runif(100,-320,-300))
coin2 <- list(id = "coin2", assoc = "G", type = NULL, samples = seq(37, 41, length = 100))
destr <- list(id = "destr", assoc = "J", type = NULL, samples = 79)

tpq_info <- list(coin1, coin2)
taq_info <- list(destr)

result <- gibbs_ad(contexts, finds = artifacts, tpq = tpq_info, taq = taq_info)

# deposition of "B"
histogram(result, "B")

# deposition of "coin2" and deposition of "G"
histogram(result, c("coin2", "G"), opacity = 0.5)

# production of "type2" and deposition of "H"
histogram(result, c("H", "type2"), opacity = 0.5)

# production, use, and deposition of "type1"
type1_use <- gibbs_ad_use(result, artifacts, type = "type1",
                          max_samples = 1000, size = 500, mcse_crit = 2)
histogram(type1_use)

}
