% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_diagnostic_cl}
\alias{plot_diagnostic_cl}
\title{Diagnostic plot for R estimation from clinical report data}
\usage{
plot_diagnostic_cl(r.estim, caption = NULL, wrap.plots = TRUE)
}
\arguments{
\item{r.estim}{List. Output of \code{\link[=estimate_R_cl]{estimate_R_cl()}}.}

\item{caption}{String. Caption to be inserted in the plot.
Default is \code{caption = NULL} which disables the caption.}

\item{wrap.plots}{Logical. Wrap the plots together into a single ggplot object?
If \code{wrap.plots = TRUE} (the default) will return wrapped plots in a single object,
else will return a list of separate ggplot objects.}
}
\value{
Plots of the clinical data used, the inferred daily incidence and
Rt estimates. If \code{wrap.plots = TRUE} (the default) will return
wrapped plots (with x-axis aligned to facilitate the comaprison)
in a single object,
else will return a list of separate ggplot objects.

A \code{ggplot} object (or a list of ggplot objects
if \code{wrap.plots = FALSE}).
}
\description{
Diagnostic plot for R estimation from clinical report data
}
\examples{

# -- THIS EXAMPLE TAKES ABOUT 30 SECONDS TO RUN --
# Estimate Rt

\dontrun{
# Load SARS-CoV-2 reported cases in Quebec
# during the Summer 2021
dat <- (ern::cl.data
    |> dplyr::filter(
      pt == "qc", 
      dplyr::between(date, as.Date("2021-06-01"), as.Date("2021-09-01"))
    )
)
# distributions
dist.repdelay = ern::def_dist(
    dist = 'gamma',
    mean = 5, 
    mean_sd = 1,
    sd = 1,
    sd_sd = 0.1,
    max = 10
)
dist.repfrac = ern::def_dist(
    dist = "unif",
    min = 0.1,
    max = 0.3
)
dist.incub = ern::def_dist(
    dist = "gamma",
    mean = 3.49,
    mean_sd = 0.1477,
    shape = 8.5,
    shape_sd = 1.8945,
    max = 8
)
dist.gi = ern::def_dist(
    dist = "gamma",
    mean = 6,
    mean_sd = 0.75,
    shape = 2.4,
    shape_sd = 0.3,
    max = 10
)

# settings
prm.daily <- list(
    method = "renewal",
    popsize = 8.5e6, # Q3 (July 1) 2022 estimate for Quebec
    burn = 500,
    iter = 500,
    chains = 2,
    prior_R0_shape = 1.1, prior_R0_rate = 0.6, 
    prior_alpha_shape = 1, prior_alpha_rate = 1
)
prm.daily.check <- list(
    agg.reldiff.tol = 10
)
prm.smooth <- list(
    method = "rollmean",
    align = "center",
    window = 7
)
prm.R <- list(
    iter = 20, 
    CI = 0.95, 
    window = 7, 
    config.EpiEstim = NULL
)

x <- estimate_R_cl(
  dat,
  dist.repdelay,
  dist.repfrac,
  dist.incub,
  dist.gi,
  prm.daily,
  prm.daily.check,
  prm.smooth,
  prm.R
)

# Diagnostic plot for Rt estimates 
# from clinical data
g = plot_diagnostic_cl(x)
plot(g)

g2 = plot_diagnostic_cl(x, caption = 'This is your caption', wrap.plots = FALSE)
plot(g2$clinical_data)
plot(g2$inferred_incidence)
plot(g2$Rt)
}

}
\seealso{
\code{\link[=estimate_R_cl]{estimate_R_cl()}}
}
