% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_gettemperature.R
\name{aux_gettemperature}
\alias{aux_gettemperature}
\title{Extract temperature data from cube files.}
\usage{
aux_gettemperature(input_dir, logger_ID, interval, cpu, gipptools)
}
\arguments{
\item{input_dir}{\code{Character} value, path to directory where all cube 
files to be processed as stored. Each set of files from one logger must be 
stored in a separate sub-directory named after the cube ID.}

\item{logger_ID}{\code{Character} vector, logger ID.}

\item{interval}{\code{Numeric} value, time interval (minutes) to which
temperature data is interpolated. No interpolation is performed if this 
argument is omitted.}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use for parallel 
processing. If omitted, one CPU is used.}

\item{gipptools}{\code{Character} value, path to gipptools or cubetools 
directory.}
}
\value{
A \code{list} of \code{data frames} with time and temperature 
values for each cube data logger.
}
\description{
This function reads auxiliary information stored in Omnirecs/Digos Datacube  
files and extracts the temperature data that is stored along with each GPS 
tag. Optionally, the data is interpolated to equal intervals.
}
\details{
This feature is ony available for  Omnirecs/Digos Datacube that were 
produced since 2015, i.e., whose GPS output files also record the 
temperature inside the logger. Generating an ACSII GPS tag file using the 
gipptools software requires a few minutes time per daily file.
}
\examples{

## uncomment to use
# t <- aux_gettemperature(input_dir = "input",
#                         logger_ID = c("ANN", "ABT"),
#                         interval = 15,
#                         gipptools = "~/software/gipptools-2015.225/")

}
\author{
Michael Dietze
}
\keyword{eseis}
