% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desviacion.R
\name{desviacion}
\alias{desviacion}
\title{Desviación típica.}
\usage{
desviacion(x, variable = NULL, pesos = NULL, tipo = c("muestral", "cuasi"))
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, el argumento variable es NULL. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{pesos}{Si los datos de la variable están resumidos en una distribución de frecuencias, debe indicarse la columna que representa los valores de la variable y la columna con las frecuencias o pesos.}

\item{tipo}{Es un carácter. Por defecto de calcula la desviación típica muestral (\code{tipo = "muestral"}). Si \code{tipo = "cuasi"}, se calcula la cuasi-desviación típica muestral.}
}
\value{
Esta función devuelve un objeto de la clase \code{vector}. Si \code{tipo="muestral"}, devuelve la desviación típica muestral. Si \code{tipo="cuasi"}, devuelve la cuasi-desviación típica muestral.
}
\description{
Calcula la desviación típica.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrdispersion.png}{width = 200px}}
\if{latex}{\figure{qrdispersion.png}{options: width=3cm}}
}
\details{
(1) La expresión de la de la desviación típica muestral es:

\if{html}{\figure{desviacion.png}{width = 32px}}
\if{latex}{\figure{desviacion.png}{options: width=5cm}}

La desviación típica muestral así definida es el estimador máximo verosímil de la desviación típica de una población normal

(2) Muchos manuales y prácticamente todos los softwares (SPSS, Excel, etc.) calculan la expresión:

\if{html}{\figure{cuasidesviacion.png}{width = 320px}}
\if{latex}{\figure{cuasidesviacion.png}{options: width=5cm}}

Nosotros llamamos a esta medida: cuasi-desviación típica muestral y es un estimador insesgado de la desviación típica poblacional.
}
\note{
Si en lugar del tamaño muestral (n) se utiliza el tamaño de la población (N) se obtiene la desviación típica poblacional:

\if{html}{\figure{desviacionpob.png}{width = 320px}}
\if{latex}{\figure{desviacionpob.png}{options: width=5cm}}
}
\examples{

desviacion1 <- desviacion(startup[1])
desviaciona2 <- desviacion(startup,variable=1)
desviacion3 <- desviacion(startup,variable=1, tipo="cuasi")

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{media}}, \code{\link{varianza}}, \code{\link{coeficiente.variacion}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
