% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{W_priors}
\alias{W_priors}
\title{Set prior specifications for the spatial weight matrix}
\usage{
W_priors(
  n,
  W_prior = matrix(0.5, n, n),
  symmetric_prior = FALSE,
  row_standardized_prior = TRUE,
  nr_neighbors_prior = bbinompdf(0:(n - 1), nsize = n - 1, a = 1, b = 1, min_k = 0, max_k
    = n - 1)
)
}
\arguments{
\item{n}{The number of spatial observations}

\item{W_prior}{An \eqn{n} by \eqn{n} matrix of prior inclusion probabilities for \eqn{W}}

\item{symmetric_prior}{Binary value. Should the estimated adjacency matrix \eqn{\Omega} be symmetric (default: FALSE)?
if TRUE: \eqn{\Omega} is forced symmetric; if FALSE: \eqn{\Omega} not necessarily symmetric.}

\item{row_standardized_prior}{Binary value. Should the estimated \eqn{W} matrix be row-standardized (default: TRUE)?
if TRUE: row-stochastic \eqn{W}; if FALSE: \eqn{W} not row-standardized.}

\item{nr_neighbors_prior}{An \eqn{n} dimensional vector of prior weights on the number of neighbors
(i.e. the row sums of the adjacency matrix \eqn{\Omega}), where the first element denotes the prior probability
of zero neighbors and the last those of \eqn{n-1}. A prior using only fixed inclusion probabilities
for the entries in \eqn{\Omega} would be an \eqn{n} dimensional vector of \eqn{1/n}. Defaults to
a \code{\link{bbinompdf}} prior, with prior parameters \eqn{a = 1}, \eqn{b = 1}.}
}
\description{
Set prior specifications for the \eqn{n} by \eqn{n} spatial weight matrix \eqn{W=f(\Omega)},
where \eqn{\Omega} is an \eqn{n} by \eqn{n} unknown binary adjacency matrix (with zeros on the
main diagonal), and \eqn{f()} denotes the (optional) row-standardization function
}
