% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngamma.R
\name{normalgamma}
\alias{normalgamma}
\title{A Markov Chain Monte Carlo (MCMC) sampler for a linear panel model}
\usage{
normalgamma(
  Y,
  tt,
  X = matrix(1, nrow(Y), 1),
  niter = 200,
  nretain = 100,
  beta_prior = beta_priors(k = ncol(X)),
  sigma_prior = sigma_priors()
)
}
\arguments{
\item{Y}{numeric \eqn{N \times 1} matrix containing the dependent variables, where \eqn{N = nT} is the number of
spatial (\eqn{n}) times the number of time observations (\eqn{T}, with \code{tt=T}). Note that the observations
have organized such that \eqn{Y = [Y_1',...,Y_T']'}.}

\item{tt}{single number greater or equal to 1. Denotes the number of time observations. \eqn{tt = T}.}

\item{X}{numeric \eqn{N \times k_1} design matrix of independent variables.}

\item{niter}{single number greater or equal to 1, indicating the total number of draws.
Will be automatically coerced to integer. The default value is 200.}

\item{nretain}{single number greater or equal to 0, indicating the number of draws
kept after the burn-in. Will be automatically coerced to integer. The default value is 100.}

\item{beta_prior}{list containing priors for the slope coefficients \eqn{\beta},
generated by the smart constructor \code{\link{beta_priors}}.}

\item{sigma_prior}{list containing priors for the error variance \eqn{\sigma^2},
generated by the smart constructor \code{\link{sigma_priors}}}
}
\description{
The sampler uses independent Normal-inverse-Gamma priors to estimate a linear panel data model. The function is
used for an illustration on using the \code{\link{beta_sampler}} and \code{\link{sigma_sampler}} classes.
}
\details{
The considered model takes the form:

\deqn{
 Y_t = X_t \beta + \varepsilon_t,
 }

with \eqn{\varepsilon_t \sim N(0,I_n \sigma^2)}.

\eqn{Y_t} (\eqn{n \times 1}) collects the \eqn{n} cross-sectional observations for time
\eqn{t=1,...,T}. \eqn{X_t} (\eqn{n \times k_1}) is a matrix of explanatory variables.
\eqn{\beta} (\eqn{k_1 \times 1}) is an unknown slope parameter matrix.

After vertically staking the \eqn{T} cross-sections  \eqn{Y=[Y_1',...,Y_T']'} (\eqn{N \times 1}),
\eqn{X=[X_1',...,X_T']'} (\eqn{N \times k}), with \eqn{N=nT}, the final model can be expressed as:

\deqn{
 Y = X \beta + \varepsilon,
}

where \eqn{\varepsilon \sim N(0,I_N \sigma^2)}. Note that the input
data matrices have to be ordered first by the cross-sectional (spatial) units and then stacked by time.
}
\examples{
n = 20; tt = 10; k = 3
X = matrix(stats::rnorm(n*tt*k),n*tt,k)
Y = X \%*\% c(1,0,-1) + stats::rnorm(n*tt,0,.5)
res = normalgamma(Y,tt,X)
}
