% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk.R
\name{crosswalk}
\alias{crosswalk}
\title{Convert habitat codes}
\usage{
crosswalk(code, from, to, unnest = FALSE)
}
\arguments{
\item{code}{A character vector of habitat codes. These values should be existing codes in the classification system indicated in the \code{from} parameter.}

\item{from}{The source classification system. Should be one of:
\code{"EUNIS_2012"}, \code{"EUNIS_M_2019"}, \code{"EUNIS_M_2022"}, \code{"EUNIS_T_2021"},
\code{"RL"} or \code{"Annex_I"}.}

\item{to}{The target classification system. Also, one of the options
indicated in \code{from} parameter description.}

\item{unnest}{Whether to unnest the "to" column in the output. Note that if
you do unnest then the number of rows in the output will be (potentially)
greater than the number of habitat codes provided in the parameter \code{code},
meaning that the one-to-many crosswalks will be on one row each.}
}
\value{
A \link[tibble:tibble-package]{tibble} of two variables with the from and
to codes, respectively. The actual column names will vary according to the
specific crosswalk queried, see Examples.
}
\description{
Convert (crosswalk) habitat codes from, and to, the following habitat
classification systems:
\itemize{
\item EUNIS habitat classification: \code{"EUNIS_2012"}, \code{"EUNIS_M_2019"}, \code{"EUNIS_M_2022"} and \code{"EUNIS_T_2021"}. See \link{eunis_habitats} for these habitat codes, names and descriptions.
\item European Red List of Habitats: \code{"RL"}.
\item Habitats Directive Annex I: \code{"Annex_I"}.
}

Note that not all pairwise combinations are available. The possibilities are
those originally provided in EUNIS raw data.
}
\examples{
# From EUNIS 2012 to EUNIS Marine 2022
crosswalk(
  code = c("A3.4", "A3.5"),
  from = "EUNIS_2012",
  to = "EUNIS_M_2022",
  unnest = TRUE
)

# From EUNIS Marine 2019 to EUNIS 2012
crosswalk(
code = c("MH152", "MH2331"),
from = "EUNIS_M_2019",
to = "EUNIS_2012",
unnest = TRUE
)

# From EUNIS Marine 2022 to Red List
crosswalk(
code = c("MH152", "MH2331", "MA146", "MD55"),
from = "EUNIS_M_2022",
to = "RL",
unnest = TRUE
)

# From EUNIS Marine 2019 to Annex I
crosswalk(
code = c("M", "MA1", "MA11", "MA12"),
from = "EUNIS_M_2019",
to = "Annex_I", unnest = TRUE
)

# From Annex I to EUNIS Marine 2019
crosswalk(
code = c("8330", "1160"),
from = "Annex_I",
to = "EUNIS_M_2019", unnest = TRUE
)

# From EUNIS Terrestrial 2021 to Annex I
crosswalk(
code = c("U51", "U72", "Q25"),
from = "EUNIS_T_2021",
to = "Annex_I", unnest = TRUE
)

# From Annex I to EUNIS Terrestrial 2021
crosswalk(
  code = c("91E0", "92A0", "9030"),
  from = "Annex_I",
  to = "EUNIS_T_2021", unnest = TRUE
  )

}
