% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-competition-metadata.R
\name{getCompetitionHistory}
\alias{getCompetitionHistory}
\alias{getCompetitionRounds}
\alias{getCompetitionPhases}
\alias{getCompetitionTeams}
\alias{getCompetitionGames}
\title{Competition metadata}
\usage{
getCompetitionHistory(competition_code)

getCompetitionRounds(season_code)

getCompetitionPhases(season_code)

getCompetitionTeams(season_code)

getCompetitionGames(season_code, round, phase_type = "All")
}
\arguments{
\item{competition_code}{One or more competition codes.\cr
Admitted values are \code{E} for Euroleague and \code{U} for Eurocup.}

\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}

\item{phase_type}{One or more phase type codes as obtained from \code{\link[=getCompetitionPhases]{getCompetitionPhases()}}.\cr
Admitted values are \code{RS} for regular season, \code{PO} for playoffs and \code{FF} for final four.
Default is \code{All} for all.}
}
\value{
For each function, returns a tibble with information about history,
rounds, phases, teams or games of chosen season and competition code.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Retrieve values of arguments for specific data collection functions across all package.
}
\examples{

\dontrun{

getCompetitionHistory(competition_code = c("E", "U")) |> head(5)

getCompetitionRounds(season_code = c("E2023", "E2022")) |> head(5)

getCompetitionPhases(season_code = c("E2023", "U2023")) |> head(5)

getCompetitionTeams(season_code = c("E2023", "U2023")) |> head(5)

getCompetitionGames(season_code = "E2023", round = 1:5) |> head(5)

}
}
\keyword{competitionMetadata}
