% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{eval_text}
\alias{eval_text}
\title{safely evaluate text}
\usage{
eval_text(
  text,
  singular_operators = NULL,
  binary_operators = NULL,
  valid_functions = NULL,
  map = NULL,
  mapping_names = NULL
)
}
\arguments{
\item{text}{the string/code/statement you want to parse.}

\item{singular_operators}{tokens of length 1 that operate on a right hand value. For example, the `-` token is an operator to negate a vector. \code{NULL} value will be replaced with \code{c("-", "!")}.}

\item{binary_operators}{tokens of any length that operate on a left and right hand values. For example, the `+` token is an operator that adds a left vector to a right vector. \code{NULL} value will be replaced with \code{c(",", "|", "&", "<=", "<", ">=", ">", "==", "!=", "+", "-", "*", "\%/\%", "/", "\%\%", "\%in\%", ":", "^")}. The order determines the precedence of the operators.}

\item{valid_functions}{tokens of any length that are prefixed on a parenthesis block and specify a function to run on the provided parameters within the block. For example, the `log` token will evaluate the logarithm value of the first parameter. Note named parameters are not support. \code{NULL} value will be replaced with \code{c("log", "c", "any", "all", "abs", "ifelse")}.}

\item{map}{a named list of data.frames/lists/matrices. Where names are keys for referencing the values in the \code{text} parameters.}

\item{mapping_names}{optional argument to make the function faster or limit which map elements can be referenced.}
}
\value{
numeric or logical vector
}
\description{
Safe alternative to using eval + parse
}
\details{
See \code{vignette("Overview", package = "evalR")}
}
\examples{
eval_text("1 + 2")

# using the map parameter 
map_obj <- list("#" = data.frame(x = 1:5, y = 5:1),"$" = list(z = -(1:5)))
y <- evalR::eval_text("#x# + $z$", map=map_obj)
}
