% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_table_flex.R
\name{read_table_flex}
\alias{read_table_flex}
\title{Flexible and fast table reader using data.table::fread}
\usage{
read_table_flex(
  file_path,
  sep = NULL,
  encoding = "UTF-8",
  header = TRUE,
  df = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{file_path}{Character. Path to the file to be read.}

\item{sep}{Optional. Field delimiter. If \code{NULL}, auto-detected by file extension.}

\item{encoding}{Character. File encoding accepted by fread: "unknown", "UTF-8", or "Latin-1".}

\item{header}{Logical. Whether the file contains a header row. Default: \code{TRUE}.}

\item{df}{Logical. Return data.frame instead of data.table. Default: \code{TRUE}.}

\item{verbose}{Logical. Show progress and details. Default: \code{FALSE}.}
}
\value{
A \code{data.frame} (default) or \code{data.table} depending on \code{df} parameter.
}
\description{
Robust table reader with auto delimiter detection for \code{.csv}, \code{.tsv}, \code{.txt},
and their \code{.gz} variants. Uses \code{data.table::fread()} and prints CLI messages.
}
