% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_anova.R
\name{quick_anova}
\alias{quick_anova}
\title{Quick ANOVA with Automatic Method Selection}
\usage{
quick_anova(
  data,
  group,
  value,
  method = c("auto", "anova", "welch", "kruskal"),
  post_hoc = c("auto", "none", "tukey", "welch", "wilcox"),
  conf.level = 0.95,
  plot_type = c("boxplot", "violin", "both"),
  add_jitter = TRUE,
  point_size = 2,
  point_alpha = 0.6,
  show_p_value = TRUE,
  p_label = c("p.format", "p.signif"),
  palette = "qual_vivid",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{group}{Column name for the grouping factor. Supports quoted or
unquoted names via tidy evaluation.}

\item{value}{Column name for the numeric response variable.}

\item{method}{Character. One of "auto" (default), "anova", "welch",
or "kruskal". When "auto", the function inspects normality and
homogeneity of variances to pick an appropriate test.}

\item{post_hoc}{Character. Post-hoc procedure: "auto" (default), "none",
"tukey", "welch", or "wilcox". "auto" selects Tukey for ANOVA,
Welch-style pairwise t-tests for Welch ANOVA, and pairwise Wilcoxon
tests for Kruskal-Wallis.}

\item{conf.level}{Numeric. Confidence level for the test/intervals.
Default is 0.95.}

\item{plot_type}{Character. One of "boxplot", "violin", or "both".}

\item{add_jitter}{Logical. Add jittered points? Default TRUE.}

\item{point_size}{Numeric. Size of jitter points. Default 2.}

\item{point_alpha}{Numeric. Transparency for jitter points (0-1). Default 0.6.}

\item{show_p_value}{Logical. Show omnibus p-value on the plot? Default TRUE.}

\item{p_label}{Character. P-value display: "p.format" (default) or
"p.signif" (stars).}

\item{palette}{Character. Palette name from evanverse, or NULL for defaults.}

\item{verbose}{Logical. Print informative messages? Default TRUE.}

\item{...}{Reserved for future extensions.}
}
\value{
An object of class \code{quick_anova_result} with elements:
\describe{
\item{plot}{ggplot object of the comparison}
\item{omnibus_result}{List describing the main test}
\item{post_hoc}{Post-hoc comparison table (if requested)}
\item{method_used}{Character. "anova", "welch", or "kruskal"}
\item{descriptive_stats}{Summary statistics by group}
\item{assumption_checks}{Results of normality/variance checks}
\item{auto_decision}{Details explaining automatic selections}
\item{timestamp}{POSIXct timestamp of the analysis}
}
}
\description{
Conduct one-way ANOVA, Welch ANOVA, or Kruskal-Wallis test with automatic
assumption checks, publication-ready visualization, and optional post-hoc
comparisons. Designed for comparing two or more independent groups.
}
\examples{
set.seed(123)
df <- data.frame(
  group = rep(LETTERS[1:3], each = 40),
  value = rnorm(120, mean = rep(c(0, 0.5, 1.2), each = 40), sd = 1)
)
res <- quick_anova(df, group, value)
res$plot
summary(res)

}
\seealso{
\code{\link[stats]{aov}}, \code{\link[stats]{oneway.test}},
\code{\link[stats]{kruskal.test}}
}
