% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_u2.R
\name{calc_u2}
\alias{calc_u2}
\alias{calc_u2,Raster-method}
\alias{calc_u2,character-method}
\alias{calc_u2,data.table-method}
\title{Calculate Wind Speed at 2 Meters (u2)}
\usage{
calc_u2(x, z_u = 10)

\S4method{calc_u2}{Raster}(x, z_u = 10)

\S4method{calc_u2}{character}(x, z_u = 10)

\S4method{calc_u2}{data.table}(x, z_u = 10)
}
\arguments{
\item{x}{A `Raster*` object, a file path (`character`) to a raster file, or a `data.table` containing wind speed data.}

\item{z_u}{Measurement height (m) of the provided wind speed. Default is 10.}
}
\value{
Wind speed adjusted to 2 meters, returned as:
\itemize{
  \item A `RasterBrick`, if input is a raster object or file path.
  \item A `data.table` with updated `"value"` column, if input is a `data.table`.
}
}
\description{
Computes wind speed at 2 meters (u2) based on wind speed measured at a different height (`z_u`).
}
\details{
For raster inputs, provide a `Raster*` object or file path (`character`) for wind speed at height `z_u`. 
For `data.table` input, provide a single `data.table` with columns: `"lon"`, `"lat"`, `"date"`, and `"value"`, 
where `"value"` contains wind speeds at height `z_u`.

If `z_u` is 2, the function returns the input unchanged.
}
\examples{
\donttest{
# Raster input
if (requireNamespace("raster", quietly = TRUE)) {
  wind_path <- file.path(tempdir(), "wind_speed.nc")

  if (file.exists(wind_path)) {
    dummie_u <- raster::brick(wind_path)
    u2_raster <- calc_u2(dummie_u, z_u = 10)
  }
}

# File path input
wind_path <- file.path(tempdir(), "wind_speed.nc")
if (file.exists(wind_path)) {
  u2_from_file <- calc_u2(wind_path, z_u = 10)
}

# data.table input
if (requireNamespace("data.table", quietly = TRUE)) {
  dt <- data.table::data.table(
    lon = c(10.0, 10.5),
    lat = c(45.0, 45.5),
    date = as.Date(c("2001-06-01", "2001-06-02")),
    value = c(3.5, 4.1)
  )
  u2_dt <- calc_u2(dt, z_u = 10)
}
}
}
