% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_level_disagreement.R
\name{event_level_disagreement}
\alias{event_level_disagreement}
\title{Calculate event-level disagreement scores by variable (wide format)}
\usage{
event_level_disagreement(data, group_var, variables)
}
\arguments{
\item{data}{A data frame containing event report level data.}

\item{group_var}{A character string naming the column that uniquely identifies events (e.g., "event_id").}

\item{variables}{A character vector of column names to check for disagreement.}
}
\value{
A wide-format tibble where each row is an event and each column is a disagreement score for a variable.
}
\description{
This function calculates the level of disagreement across event reports for each event and variable.
For a given event and variable, it computes 1 minus the proportion of reports that agree with the modal value.
A score of 0 indicates full agreement, while higher scores indicate greater disagreement.
}
\details{
The result is a wide-format tibble with one row per event and one column per variable.
}
\examples{
df <- data.frame(
  event_id = c(1, 1, 2, 2, 3),
  actor1 = c("Actor A", "Actor B", "Actor B", "Actor B", "Actor C"),
  deaths_best = c(10, 10, 5, 15, 10)
)
event_level_disagreement(
  df,
  group_var = "event_id",
  variables = c("actor1", "deaths_best")
)
}
