% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macro_pred.R
\name{macro_pred}
\alias{macro_pred}
\title{Macroevolutionary predictions}
\usage{
macro_pred(y, V, useLFO = TRUE)
}
\arguments{
\item{y}{vector of species means}

\item{V}{phylogenetic variance matrix, must have same order as \code{y}}

\item{useLFO}{excludes the focal species when calculating the corresponding
species' mean. The correct way is to use TRUE, but in practice it has
little effect and FALSE will speed up the model fit.}
}
\value{
\code{macro_pred} returns a of macroevolutionary predictions at the
tips.
}
\description{
\code{macro_pred} Macroevolutionary predictions
}
\details{
\code{macro_pred} Gives a vector of macroevolutionary predictions for each
species based on the other species given the phylogeny and a phylogenetic
variance matrix.
}
\examples{
# Trait values
y <- rnorm(3)

# A variance matrix (the diagonal must be the same order as y).
V <- matrix(c(1.0, 0.5, 0.2, 0.5, 1.0, 0.4, 0.2, 0.4, 1.0), ncol = 3)

# Macroevolutionary predictions (output in the same order as y).
macro_pred(y, V)
}
\author{
Geir H. Bolstad
}
