% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{lamDiff}
\alias{lamDiff}
\title{Difference in lambda}
\usage{
lamDiff(Aobj, which.fixed = NULL)
}
\arguments{
\item{Aobj}{An object containing the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where
each row is the column-wise vectorization of a matrix. Exactly 2 matrices
should be provided. If more than 2 matrices are provided, the function will
assume that the first is the baseline and the second is the observed matrix
to be compared. Matrices beyond the first two will be ignored.}

\item{which.fixed}{The column-wise indices (single-value index) of the vital
rates to be held at their baseline values across the matrices in \code{Aobj}.}
}
\value{
A single value for the difference in lambda.
}
\description{
In population projection matrices, the eigenvalue with the largest magnitude
is the asymptotic population growth rate, referred to as lambda. This
function calculates the difference in lambda between two population
projection matrices, which must have the same dimensions. This function also
has the option to hold some of the vital rates at the value in the baseline
matrix. The resulting calculation is the difference in lambda when all the
non-fixed vital rates are varying. For example, if all the vital rates are
held fixed except for adult fertility, then the output is the difference in
lambda due to difference in adult fertility. The difference is taken as
\eqn{baseline matrix - observed matrix}, and the function assumes that the
provided matrices are ordered [baseline, observed].
}
\details{
This function differs from \code{lamDiff_symmetric} because it uses the first
matrix in \code{Aobj} as the baseline matrix. So fixed parameters are set to
the values in the baseline matrix. In \code{lamDiff_symmetric}, the fixed
parameters would be set to their mean values.

\code{lamDiff} is most appropriate for comparisons between a control and
treatment population in a controlled experiment or other settings where one
of the populations can be considered as a standard-of-reference.
\code{lamDiff_symmetric} is more appropriate for comparisons where none of
the population matrices are obviously suitable as a baseline or
standard-of-reference (for example, when comparing a wet and a dry year).
}
\examples{
Abaseline<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
Aobserved<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A_all<- list(Abaseline,Aobserved)
diff_all_vary<- lamDiff(A_all)
diff_fert_vary<- lamDiff(A_all, which.fixed=c(2,6,9))
}
\seealso{
\code{\link{lamDiff_symmetric}} \code{\link{lamVar}}
}
