% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographic_fns.R
\name{mean_matrix}
\alias{mean_matrix}
\title{Calculate the mean matrix}
\usage{
mean_matrix(Aobj)
}
\arguments{
\item{Aobj}{A list of matrix population models, which must all have the same
dimensions.}
}
\value{
A single population projection matrix, with the same dimensions as
the provided ones, where all vital rate entries are the mean across all
provided matrices at the respective matrix index.
}
\description{
Calculate the mean matrix from a list of matrices. In the mean matrix, each
element of the matrix is the mean value at that indexed position, across all
the provided matrices.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
Amean<- mean_matrix(list(A1,A2,A3))
}
