% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/now.R
\name{now}
\alias{now}
\title{Current Time}
\usage{
now(last = 35)
}
\arguments{
\item{last}{integer: the amount of digits that should be returned (default: \code{35})}
}
\value{
A character.
}
\description{
Returns a time stamp based on the current time. \code{now} basically calls
\code{gsub('.', '', sprintf('\%.20f', as.numeric(Sys.time())), fixed=TRUE)}.
To ensure that at each call a different time stamp is delivered \code{now}
may call \code{gsub(...)} several times until two different results are delivered.
The last one is then returned.
}
\examples{
now()   # returns all digits
now(3)  # returns only the first three digits
}
