% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means_choice.R
\name{means_choice}
\alias{means_choice}
\alias{means}
\title{Means}
\usage{
means_choice(x, digits, na.rm = TRUE, trim = 0.2, winsor = 0.2)

means(x, digits, na.rm = TRUE, trim = 0.2, winsor = 0.2)
}
\arguments{
\item{x}{numeric: data values}

\item{digits}{numeric:    integer indicating the number of decimal points for rounding (negative values are allowed)}

\item{na.rm}{logical: should \code{NA}s be removed before?}

\item{trim}{numeric: the fraction (0 to 0.5) of observations to be trimmed from each end of \code{x}}

\item{winsor}{numeric: the fraction (0 to 0.5) of observations to be moved from each end of \code{x}}
}
\value{
A list with mean values.
}
\description{
Computes the means of \code{x}. The list returned has an attribute \code{"mindiff"} which contains
the smallest distance between two mean values before rounding.
If \code{winsor} and/or \code{trim} is set to \code{NA} then the trimmed and/or winsorized means are not computed.
Currently implemented are:
\describe{
\item{\code{mean}}{arithmetic mean}
\item{\code{median}}{median}
\item{\code{harmonic}}{harmonic mean}
\item{\code{geometric}}{geometric mean}
\item{\code{mode}}{(first) mode}
\item{\code{trim}}{trimmed mean}
\item{\code{winsor}}{winsorized mean}
}
}
\examples{
x <- c(runif(9), 3)
means_choice(x, 2)
}
