% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{getComments}
\alias{getComments}
\title{This function is used to get comment from specified cell}
\usage{
getComments(tableId, cellId)
}
\arguments{
\item{tableId}{the id of the table from which the comment is to be fetched}

\item{cellId}{the id of the cell from which the comment is to be fetched}
}
\description{
This function is used to get comment from specified cell
}
\examples{
if(interactive()) {
 library(shiny)
 library(excelR)
 shinyApp(
     ui = fluidPage(excelOutput("table", height = 175),
          actionButton('comment', 'Get Comments from cell A1')),
     server = function(input, output, session) {
         output$table <- renderExcel(excelTable(data = head(iris)))
         observeEvent(input$comment, {
             getComments("table", "A1")
         })
         observeEvent(input$table, {
         print(input$table$comment)
         })
     }
     )
 }
}
