% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exal.R
\name{dexal}
\alias{dexal}
\title{Density Function for the Extended Asymmetric Laplace (exAL) Distribution}
\usage{
dexal(x, p0 = 0.5, mu = 0, sigma = 1, gamma = 0, log = FALSE)
}
\arguments{
\item{x}{Numeric vector of quantiles.}

\item{p0}{Probability level used in the quantile parametrization. Scalar in (0, 1). Default \code{0.5}.}

\item{mu}{Location parameter (scalar). Default \code{0}.}

\item{sigma}{Scale parameter (scalar, strictly positive). Default \code{1}.}

\item{gamma}{Skewness parameter controlling asymmetry (scalar). Must be within valid bounds implied by \code{p0}. Default \code{0}.}

\item{log}{Logical scalar; if \code{TRUE} return log-density. Default \code{FALSE}.}
}
\value{
Numeric vector of densities (same length as \code{x}).
}
\description{
Computes the PDF of the Extended Asymmetric Laplace (exAL) distribution.
Vectorized over \code{x}.
}
\examples{
dexal(0)
dexal(1, p0 = 0.75, mu = 0, sigma = 2, gamma = 0.25)
dexal(seq(-3, 3, by = 0.1), p0 = 0.3, mu = 0, sigma = 1, gamma = -0.45)

}
