% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_subsets.R
\name{remove_subsets}
\alias{remove_subsets}
\title{removes subsets or supersets of item combinations}
\usage{
remove_subsets(obj, keep_longest = FALSE)
}
\arguments{
\item{obj}{either a list of vectors of item combinations (typically the
passed_combos slot of an object of class passed_exRa or an object of
 \link{passed_exRa-class}. If combos is an object of
  \link{passed_exRa-class}, all process data (the process slot) and for
   any removed item combination also the fit models in the passed_models
    slot will be removed.}

\item{keep_longest}{boolean; if TRUE, the respective superset is kept
(and all subsets of these supersets are removed), if FALSE all subsets
 is kept (and supersets of these subsets are removed).}
}
\value{
depending of the class of obj, either a list of numeric vectors
 containing the remaining item combinations or an object of
  \link{passed_exRa-class} with the remaining item combinations,
   fit models and information criteria, but without the process
    information.
}
\description{
removes subsets or supersets of item combinations
}
\examples{
\donttest{
  library(exhaustiveRasch)
  data(ADL)
  passed_ADL <- exhaustive_tests(dset=ADL[1:15], scale_length=4:5,
    modelType= "RM", na.rm=TRUE, tests= c("test_LR"),
    splitcr_LR = ADL[,17], estimation_param = estimation_control())
  passed_shortest <- remove_subsets(passed_ADL, keep_longest=FALSE)
 }
}
