% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_psychotools.R
\name{waldtest.psy}
\alias{waldtest.psy}
\title{Fischer and Scheiblechner's "wald-like" S-statistic for psychotools}
\usage{
waldtest.psy(
  model,
  modelType,
  splitcr = "median",
  splitseed = NULL,
  icat = FALSE
)
}
\arguments{
\item{model}{an object of 'psychotools' class 'raschmodel', 'pcmodel' or
'rsmodel'  (a model previously fit using the 'psychotools' package)
 matching the value of modelType.}

\item{modelType}{a character value defining the type of Rasch model.
Possible values: "RM", "PCM", "RSM"}

\item{splitcr}{split criterion for subject raw score splitting. "median"
uses the median as split criterion, "mean" performs a mean-split,
"random" performs a random split (in this case, the seed can be set
with the "splitseed" argument. Optionally splitcr can also be a
dichotomous vector which assigns each person to a certain subgroup
(typically an external criterion). This vector can be numeric, character
or a factor.}

\item{splitseed}{seed for random split}

\item{icat}{a boolean value defining wether to use item parameters
('psychotools' function 'itempar', if TRUE) or item category parameters
('psychotools' function 'threshpar')}
}
\value{
a vector containing the p-values of the Scheiblechner's
 "wald-like" S-statistic for the items (if icat=FALSE) or for the item
 categories (if icat=TRUE).
}
\description{
Fischer and Scheiblechner's "wald-like" S-statistic for psychotools
}
\examples{
 model <- psychotools::raschmodel(ADL[c(6,7,12,14,15)])
   waldtest.psy(model=model, modelType="RM", splitcr="random", splitseed=332,
   icat=FALSE)
}
