% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2spreadsheet.R
\name{table2spreadsheet}
\alias{table2spreadsheet}
\alias{table2excel}
\alias{table2csv}
\alias{table2csv2}
\title{Export statistical output to a table in spreadsheet compatible format (.xlsx or .csv)}
\usage{
table2spreadsheet(
  x = NULL,
  file = "Rtable",
  type = c("XLS", "CSV", "CSV2"),
  append = FALSE,
  sheetName = "new sheet",
  digits = 2,
  digitspvals = 2,
  trim.pval = 1e-16,
  add.rownames = FALSE,
  ...
)

table2excel(...)

table2csv(...)

table2csv2(...)
}
\arguments{
\item{x}{given R stats object to export; if set to \code{NULL} the output of the 
previous R command will be exported.}

\item{file}{name of output file. The .xlsx or .csv extension is added automatically.}

\item{type}{desired output type - \code{"XLS"} for Excel and \code{"CSV"}/\code{"CSV2"} for CSV file. Note that 
\code{type="CSV2"} will generate a CSV file where the value separator is a semi-colon (";") and the decimal
separator is a comma (",")}

\item{append}{logical value - if \code{TRUE} and \code{type="XLS"} it will add a new woorksheet to the given 
file, where file can also be a given corporate.
\code{append=FALSE} any existing file will be overwritten.}

\item{sheetName}{a string giving the name of the new sheet that is created (only for \code{type=="XLS"}). 
It must be unique (case insensitive) from any existing sheet name in the file.}

\item{digits}{number of significant digits to show for all columns except
for the column with p values.}

\item{digitspvals}{number of significant digits to show for columns with p
values.}

\item{trim.pval}{a threshold below which the p-values are trimmed as 
"< \code{trim.pval}".}

\item{add.rownames}{logical specifying whether or not to add row names.}

\item{\dots}{extra options are passed on to \code{\link[openxlsx]{createStyle}} for the formatting of the woorksheet.
This is only applicable for \code{type=="XLS"}.}
}
\value{
A data frame
}
\description{
Export currently showing R stats object or stats object obj to a Microsoft Excel / 
LibreOffice Calc or comma-separated value file
}
\details{
Columns corresponding to degrees of freedom (with header "Df" or "df")
are always given as integers. Objects that can be exported with \code{\link{table2office}} are 
all those supported by \code{\link[xtable]{xtable}} and \code{\link[broom]{tidy}}. The function will
first use \code{\link[xtable]{xtable}} to format the data. If the data class is not supported by 
\code{\link[xtable]{xtable}} the function will then use \code{\link[broom]{tidy}}. 
The data classes suported by \code{\link[xtable]{xtable}} are: 
\itemize{
   \item \code{anova} 
   \item \code{aov} 
   \item \code{aovlist} 
   \item \code{data.frame} 
   \item \code{glm} 
   \item \code{gmsar} 
   \item \code{lagImpact} 
   \item \code{lm} 
   \item \code{matrix} 
   \item \code{prcomp} 
   \item \code{sarlm} 
   \item \code{sarlm.pred} 
   \item \code{spautolm} 
   \item \code{sphet} 
   \item \code{splm} 
   \item \code{stsls} 
   \item \code{summary.aov} 
   \item \code{summary.aovlist} 
   \item \code{summary.glm} 
   \item \code{summary.gmsar} 
   \item \code{summary.lm} 
   \item \code{summary.prcomp} 
   \item \code{summary.sarlm} 
   \item \code{summary.spautolm} 
   \item \code{summary.sphet} 
   \item \code{summary.splm} 
   \item \code{summary.stsls} 
   \item \code{table} 
   \item \code{ts} 
   \item \code{zoo}
   } 
The data classes suported by \code{\link[broom]{tidy}} are: 
\itemize{
   \item \code{aareg} 
   \item \code{acf} 
   \item \code{Arima} 
   \item \code{betareg} 
   \item \code{biglm} 
   \item \code{binDesign} 
   \item \code{binWidth} 
   \item \code{brmsfit} 
   \item \code{btergm} 
   \item \code{cch} 
   \item \code{character} 
   \item \code{cld} 
   \item \code{coeftest} 
   \item \code{confint.glht} 
   \item \code{cv.glmnet} 
   \item \code{default} 
   \item \code{density} 
   \item \code{dgCMatrix} 
   \item \code{dgTMatrix} 
   \item \code{dist} 
   \item \code{emmGrid} 
   \item \code{ergm} 
   \item \code{felm} 
   \item \code{fitdistr} 
   \item \code{ftable} 
   \item \code{gam} 
   \item \code{Gam} 
   \item \code{gamlss} 
   \item \code{geeglm} 
   \item \code{glht} 
   \item \code{glmnet} 
   \item \code{glmRob} 
   \item \code{gmm} 
   \item \code{htest} 
   \item \code{ivreg} 
   \item \code{kappa} 
   \item \code{kde} 
   \item \code{kmeans} 
   \item \code{Line} 
   \item \code{Lines} 
   \item \code{list} 
   \item \code{lme} 
   \item \code{lmodel2} 
   \item \code{lmRob} 
   \item \code{logical} 
   \item \code{lsmobj} 
   \item \code{manova} 
   \item \code{map} 
   \item \code{Mclust} 
   \item \code{merMod} 
   \item \code{mle2} 
   \item \code{muhaz} 
   \item \code{multinom} 
   \item \code{nlrq} 
   \item \code{nls} 
   \item \code{NULL} 
   \item \code{numeric} 
   \item \code{orcutt} 
   \item \code{pairwise.htest} 
   \item \code{plm} 
   \item \code{poLCA} 
   \item \code{Polygon} 
   \item \code{Polygons} 
   \item \code{power.htest} 
   \item \code{pyears} 
   \item \code{rcorr} 
   \item \code{ref.grid}
   \item \code{ridgelm} 
   \item \code{rjags} 
   \item \code{roc} 
   \item \code{rowwise_df} 
   \item \code{rq} 
   \item \code{rqs} 
   \item \code{sparseMatrix} 
   \item \code{SpatialLinesDataFrame} 
   \item \code{SpatialPolygons} 
   \item \code{SpatialPolygonsDataFrame} 
   \item \code{spec} 
   \item \code{speedlm} 
   \item \code{stanfit} 
   \item \code{stanreg} 
   \item \code{summary.glht} 
   \item \code{summaryDefault} 
   \item \code{survdiff} 
   \item \code{survexp} 
   \item \code{survfit} 
   \item \code{survreg} 
   \item \code{tbl_df} 
   \item \code{TukeyHSD}
   }
}
\section{Functions}{
\itemize{
\item \code{table2excel()}: Export statistical output to a table in a Microsoft Office Excel/ LibreOffice Calc spreadsheet

\item \code{table2csv()}: Export statistical output to a table in a CSV format ("," for value separation and "." for decimal)

\item \code{table2csv2()}: Export statistical output to a table in a CSV format (";" for value separation and "," for decimal)

}}
\examples{
# Create a file name
filen <- tempfile(pattern = "table_aov") # or 
# filen <- paste("YOUR_DIR/table_aov")

# Generate ANOVA output
fit=aov(yield ~ block + N * P + K, data = npk) # 'npk' dataset from base 'datasets'
x=summary(fit)

# Save ANOVA table as a CSV
### Option 1: pass output as object
table2csv(x=x,file=filen, digits = 1, digitspvals = 3)
### Option 2: get output from console 
summary(fit)
table2csv(file=filen, digits = 2, digitspvals = 4)

# Save ANOVA table as an Excel
# Without formatting of the worksheet
x
table2excel(file=filen, sheetName="aov_noformatting", 
            digits = 1, digitspvals = 3) 
# With formatting of the worksheet
table2excel(x=x,file=filen, sheetName="aov_formated", 
            append = TRUE, add.rownames=TRUE, fontName="Arial", 
            fontSize = 14, fontColour = rgb(0.15,0.3,0.75), 
            border=c("top", "bottom"), fgFill = rgb(0.9,0.9,0.9), 
            halign = "center", valign = "center", textDecoration="italic") 


}
\seealso{
\code{\link{table2tex}}, \code{\link{table2html}}, \code{\link{table2office}}
}
\author{
Tom Wenseleers, Christophe Vanderaa
}
