% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wz_statistics.R
\name{statistics_di}
\alias{statistics_di}
\alias{w_statistic}
\alias{z_statistic}
\title{Computes the w and z Statistics}
\usage{
w_statistic(mu, xd, s, th)

z_statistic(mu, xd, s, th)
}
\arguments{
\item{mu}{numeric: Estimated population growth rate, \eqn{\hat{\mu}}.}

\item{xd}{numeric: Distance to extinction threshold on a log scale,
\eqn{x_d = \log(n_q / n_e)}.}

\item{s}{numeric: Estimated environmental variance, \eqn{\hat{\sigma}^2}.}

\item{th}{numeric: Time horizon for extinction probability evaluation,
denoted \eqn{t^{\ast}}.}
}
\value{
numeric: Value of the statistic.
}
\description{
Estimators for the \eqn{w} and \eqn{z} statistics used in extinction
probability calculations under a density-independent population model.
}
\details{
The statistics are defined as
\deqn{
\hat w = \frac{\hat \mu t^{\ast} + x_d}{\sqrt{\hat \sigma^2 t^{\ast}}},
\qquad
\hat z = \frac{- \hat \mu t^{\ast} + x_d}{\sqrt{\hat \sigma^2 t^{\ast}}}.
}
}
\author{
Hiroshi Hakoyama, \email{hiroshi.hakoyama@gmail.com}
}
\keyword{internal}
