% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{radf_crit}
\alias{radf_crit}
\title{Stored Monte Carlo Critical Values}
\format{
A list with lower level lists that contain
\describe{
\item{adf_cv:}{Augmented Dickey-Fuller}
\item{badf_cv:}{Backward Augmented Dickey-Fuller}
\item{sadf_cv:}{Supremum Augmented Dickey-Fuller}
\item{bsadf_cv:}{Backward Supremum Augmented Dickey-Fuller}
\item{gsadf_cv:}{Generalized Supremum Augmented Dickey Fuller}

}
}
\source{
Simulated from exuber package function \code{\link{radf_mc_cv}}.
}
\usage{
radf_crit
}
\description{
A dataset containing Monte Carlo critical values for up to 600 observations
generated using the default minimum window. The critical values have been
simulated and stored as data to save computation time for the user. The stored
critical values can be obtained with the \code{\link{radf_mc_cv}}
function, using nrep = \code{2000} and the \code{seed = 123}.
}
\examples{
\dontrun{
all.equal(radf_crit[[50]], radf_mc_cv(50, nrep = 2000, seed = 123))
}
}
\keyword{datasets}
