% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ez_home_range.R
\name{ez_home_range}
\alias{ez_home_range}
\title{Estimate Home Ranges for Tracked Individuals or Population}
\usage{
ez_home_range(
  data,
  method = "mcp",
  level = 95,
  crs = NULL,
  population = FALSE,
  start_date = NULL,
  end_date = NULL,
  kde_extent = 1,
  h = "href",
  hlim = NULL
)
}
\arguments{
\item{data}{A data frame or `sf` object with columns `id`, `timestamp`, `x`, and `y`.}

\item{method}{Method for home range estimation. One of `"mcp"` (default) or `"kde"`.}

\item{level}{Percentage of points to include in the home range (e.g., 95 for 95\%). Default is 95.}

\item{crs}{Optional CRS to project the data before calculation. If NULL, uses EPSG:3857 (Web Mercator).}

\item{population}{Logical. If TRUE, returns a single home range polygon for all data combined.}

\item{start_date}{Optional. A `Date` object or string ("YYYY-MM-DD"). Filters out data before this date.}

\item{end_date}{Optional. A `Date` object or string ("YYYY-MM-DD"). Filters out data after this date.}

\item{kde_extent}{Numeric. When method = "kde", passed to `adehabitatHR::kernelUD()` to control the extent of the grid for KDE. Default is 1.}

\item{h}{Bandwidth method when method = "kde". One of `"href"` (default), "LSCV", or a numeric value.}

\item{hlim}{Optional vector of length 2 passed to `adehabitatHR::kernelUD()` when method = "kde" to constrain the bandwidth search (used with h = "LSCV").}
}
\value{
An `sf` object of home range polygon(s).
}
\description{
Computes home range polygons using either Minimum Convex Polygon (MCP) or Kernel Density Estimation (KDE).
}
