% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-check_table_values.R
\name{get_all_na_rows}
\alias{get_all_na_rows}
\title{Extract observations (rows) that have all NA values in a tibble}
\usage{
get_all_na_rows(tbl, id_col = NULL)
}
\arguments{
\item{tbl}{R object(dataframe or tibble) of the input tibble}

\item{id_col}{A character string specifying the column to ignore in
identification of repeated observations. If NULL (by default), all of the
columns will be taken in account for repeated observation identification.
The row number will be used to identify those observations.}
}
\value{
A vector string indicating either that the tibble does not have empty
observation or the row number of the empty observations.
}
\description{
This helper function extracts the row number(s) having NA value for all
columns.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# All rows have observation
get_all_na_rows(iris)

##### Example 2 -------------------------------------------------------------
# One row doesn't have any observations
library(dplyr)
get_all_na_rows(bind_rows(iris, tibble(Species = c(NA,NA))))
get_all_na_rows(
  tbl = bind_rows(iris, tibble(Species =  c('id_151', 'id_152'))),
  id_col = 'Species')

}

}
