% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_sql_connect.R
\name{fabric_sql_query}
\alias{fabric_sql_query}
\title{Run a SQL query against a Microsoft Fabric SQL endpoint (opening & closing connection)}
\usage{
fabric_sql_query(
  server,
  sql,
  database = "Lakehouse",
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID", unset =
    "04b07795-8ddb-461a-bbee-02f9e1bf7b46"),
  access_token = NULL,
  odbc_driver = getOption("fabricqueryr.sql.driver", "ODBC Driver 18 for SQL Server"),
  port = 1433L,
  encrypt = "yes",
  trust_server_certificate = "no",
  timeout = 30L,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{server}{Character. Microsoft Fabric SQL connection string or \code{Server=...} string
(see details).}

\item{sql}{Character scalar. The SQL to run.}

\item{database}{Character. Database name. Defaults to \code{"Lakehouse"}.}

\item{tenant_id}{Character. Entra ID (AAD) tenant GUID. Defaults to
\code{Sys.getenv("FABRICQUERYR_TENANT_ID")}.}

\item{client_id}{Character. App registration (client) ID. Defaults to
\code{Sys.getenv("FABRICQUERYR_CLIENT_ID")}, falling back to the Azure CLI app id
\code{"04b07795-8ddb-461a-bbee-02f9e1bf7b46"} if unset.}

\item{access_token}{Optional character. If supplied, use this bearer token
instead of acquiring a new one via \code{{AzureAuth}}.}

\item{odbc_driver}{Character. ODBC driver name. Defaults to
\code{getOption("fabricqueryr.sql.driver", "ODBC Driver 18 for SQL Server")}.}

\item{port}{Integer. TCP port (default 1433).}

\item{encrypt, trust_server_certificate}{Character flags passed to ODBC.
Defaults \code{"yes"} and \code{"no"}, respectively.}

\item{timeout}{Integer. Login/connect timeout in seconds. Default 30.}

\item{verbose}{Logical. Emit progress via \code{{cli}}. Default \code{TRUE}.}

\item{...}{Additional arguments forwarded to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}
}
\value{
A tibble with the query results (0 rows if none).
}
\description{
Convenience wrapper that opens a connection with
\code{\link[=fabric_sql_connect]{fabric_sql_connect()}}, executes \code{sql}, and returns a tibble. The
connection is closed on exit.
}
\examples{
# Example is not executed since it requires configured credentials for Fabric
\dontrun{
df <- fabric_sql_query(
  server    = "2gxz...qiy.datawarehouse.fabric.microsoft.com",
  database  = "Lakehouse",
  sql       = "SELECT TOP 100 * FROM sys.objects",
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID")
)
dplyr::glimpse(df)
}
}
