% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pAMCE.R
\name{model_pAMCE}
\alias{model_pAMCE}
\title{Estimating the population AMCE using a model-based approach}
\usage{
model_pAMCE(
  formula,
  formula_three = NULL,
  data,
  reg = TRUE,
  ord_fac,
  pair = FALSE,
  pair_id = NULL,
  cross_int = FALSE,
  cluster_id = NULL,
  target_dist,
  target_type,
  difference = FALSE,
  cv_type = "cv.1Std",
  nfolds = 5,
  boot = 100,
  seed = 1234,
  numCores = NULL
)
}
\arguments{
\item{formula}{Formula}

\item{formula_three}{Formula for three-way interactions (optional)}

\item{data}{Data}

\item{reg}{TRUE (regularization) or FALSE (no regularization). Default is TRUE}

\item{ord_fac}{Whether we assume each factor is ordered. When not specified, we assume all of them are ordered}

\item{pair}{Whether we use a paired-choice conjoint design}

\item{pair_id}{Unique identifiers for pairs in the paired-choice conjoint design  (optional)}

\item{cross_int}{Include interactions across profiles. Default is FALSE.}

\item{cluster_id}{Unique identifiers for computing cluster standard errors (optional).}

\item{target_dist}{Target profile distributions to be used. This argument should be `list`}

\item{target_type}{Types of target profile distributions. `marginal` or `target_data`. See Examples for details.}

\item{difference}{Whether we compute the differences between the multiple pAMCEs. Default is FALSE.}

\item{cv_type}{(optimal only when `reg = TRUE``)  `cv.1Std`` (stronger regularization; default) or `cv.min` (weaker regularization).}

\item{nfolds}{Number of cross validation folds. Default is 5.}

\item{boot}{The number of bootstrap samples.}

\item{seed}{Seed for bootstrap.}

\item{numCores}{Number of cores to be used for parallel computing. If not specified, detect the number of available cores internally.}
}
\value{
\code{model_pAMCE} returns an object of \code{pAMCE} class.
 \itemize{
   \item \code{AMCE}: Estimates of the pAMCE for all factors.
   \item \code{boot_AMCE}: Estimates of the pAMCE for all factors in each bootstrap sample.
   \item \code{boot_coef}: Estimates of coefficients for the linear probability model in each bootstrap sample.
   \item \code{approach}: "model_based"
   \item \code{input}: Input into the function.
   \item \code{...}: Values for internal use.
 }
}
\description{
\code{model_pAMCE} implements the model-based approach to estimate the pAMCE. See de la Cuesta, Egami, and Imai (2022) for details. More examples are available at the GitHub page of \code{factorEx}.
}
\examples{
  # Small example
  target_dist_marginal <- OnoBurden$target_dist_marginal
  OnoBurden_data <- OnoBurden$OnoBurden_data
  OnoBurden_data_small <- OnoBurden_data[1:300, ]
  target_dist_marginal_small <- target_dist_marginal[c("gender", "race")]

  # model-based estimation without regularization
  out_model_s <-
      model_pAMCE(formula = Y ~ gender + race,
           data = OnoBurden_data_small, reg = FALSE,
           pair_id = OnoBurden_data_small$pair_id,
           cluster_id = OnoBurden_data_small$id,
           target_dist  = target_dist_marginal_small,
           target_type = "marginal")

\donttest{
  # model-based estimation with regularization
  out_model <-
    model_pAMCE(formula = Y ~ gender + age + family + race + experience + party + pos_security,
                 data = OnoBurden_data_small, reg = TRUE,
                 pair_id = OnoBurden_data_small$pair_id,
                 cluster_id = OnoBurden_data_small$id,
                 target_dist  = target_dist_marginal,
                 target_type = "marginal",
                 nfolds = 2,   # suggest "nfolds = 5" in practice
                 numCores = 1, # when numCores = NULL, it automatically uses all cores.
                 boot = 5)  # suggest "boot = 500" in practice
 summary(out_model, factor_name = c("gender"))

 # decompose the difference in the pAMCEs
 decompose_pAMCE(out_model, effect_name = c("gender", "Female"))
}
}
\references{
de la Cuesta, Egami, and Imai. (2022). Improving the External Validity of Conjoint Analysis: The Essential Role of Profile Distribution. Political Analysis.

Egami and Imai. (2019). Causal Interaction in Factorial Experiments: Application to Conjoint Analysis. Journal of the American Statistical Association, Vol.114, No.526 (June), pp. 529–540.
}
