% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.srh.kway.full.tsv.R
\name{write.srh.kway.full.tsv}
\alias{write.srh.kway.full.tsv}
\title{Write full SRH pipeline result to a TSV file}
\usage{
write.srh.kway.full.tsv(
  obj,
  file = "srh_kway_full.tsv",
  sep = "\\t",
  na = "",
  dec = "."
)
}
\arguments{
\item{obj}{A list produced by \code{\link{srh.kway.full}}.}

\item{file}{Path to the output TSV file. Default \code{"srh_kway_full.tsv"}.}

\item{sep}{Field separator (default tab \code{"\\t"}).}

\item{na}{String to use for missing values (default empty string).}

\item{dec}{Decimal mark for numbers: dot \code{"."} (default) or comma \code{","}.}
}
\value{
(Invisibly) the normalized path to \code{file}.
}
\description{
Exports the result of \code{\link{srh.kway.full}} into a single,
tab-separated text file, in the order:
\emph{ANOVA} > \emph{SUMMARY} > \emph{POSTHOC CELLS} > \emph{SIMPLE EFFECTS} > \emph{META}.
Supports choosing the decimal mark for numeric values.
}
\details{
Each section is preceded by a header line (e.g., \code{## SRH: EFFECTS TABLE}).
For post hoc sections, each effect/table is prefixed with a subheader
(e.g., \code{### posthoc_cells: gender:condition}). For simple-effect tables,
the attribute \code{"adjustment"} (if present) is written as a comment line
beginning with \code{"# "}.

Components that are not applicable (e.g., simple effects in 1-factor designs)
or failed computations are written as literal one-line messages.
}
\examples{
\donttest{
data(mimicry, package = "factorH")
res <- srh.kway.full(liking ~ gender + condition, data = mimicry)

# Write to a temporary file (CRAN-safe)
f <- tempfile(fileext = ".tsv")
write.srh.kway.full.tsv(res, file = f, dec = ".")
file.exists(f)
}

}
