% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fact_main.R
\name{FACT}
\alias{FACT}
\title{Factor-Augmented Clustering Tree}
\usage{
FACT(
  X,
  Y,
  r_a = 8,
  r_b = 4,
  method = c("threshold", "permutation"),
  control = list()
)
}
\arguments{
\item{X}{A numeric matrix of covariates with dimension \eqn{N \times p},
where \eqn{N} is the number of time series and \eqn{p} is the number of features.
Each row corresponds to the covariates for one time series.}

\item{Y}{A numeric matrix of time series data with dimension \eqn{T \times N},
where \eqn{T} is the length of each series. Each column represents one time series.}

\item{r_a}{A positive integer specifying the number of singular vectors to extract
from each child node for constructing the projection matrices, default is 8.}

\item{r_b}{A positive integer specifying the number of leading singular values
to sum for the split statistic. Must satisfy \code{r_b <= r_a}, default is 2.}

\item{method}{Character string specifying the splitting decision rule:
\describe{
  \item{\code{"threshold"}}{Uses a data-adaptive threshold based on
    signal-to-noise ratio estimation. Faster but may be less accurate.
    Suitable for large datasets.}
  \item{\code{"permutation"}}{Uses a permutation test for hypothesis testing.
    More rigorous but computationally intensive.}
}}

\item{control}{A list of control parameters for tree construction:
\describe{
  \item{\code{minsplit}}{Minimum number of observations required to attempt
    a split. Default: \code{90}.}
  \item{\code{minbucket}}{Minimum number of observations in any terminal node.
    Default: \code{30}.}
  \item{\code{alpha}}{Significance level for the permutation test
    (used only when \code{method = "permutation"}). Default: \code{0.01}.}
  \item{\code{R}}{Number of permutations for the hypothesis test
    (used only when \code{method = "permutation"}). Default: \code{199}.}
  \item{\code{sep}}{Controls the density of candidate split points.
    If \code{"auto"} (default), subsamples candidates when \eqn{n > 800}.
    If numeric, evaluates every \code{sep} candidate point.}
  \item{\code{parallel}}{Logical; if \code{TRUE}, enables parallel computation.
    Default: \code{FALSE}.}
  \item{\code{n_cores}}{Number of cores for parallel processing.
    If \code{NULL} (default), uses \code{detectCores() - 1}.}
}}
}
\value{
An object of class \code{"FACT"} containing:
  \describe{
    \item{\code{frame}}{A data frame describing the tree structure, with one row
      per node. Includes split variable, split value, test statistic, and p-value
      (if applicable). A smaller test statistic indicates stronger evidence of
      heterogeneous factor structures between child nodes.}
    \item{\code{membership}}{An integer vector of length \eqn{N} indicating
      the terminal node assignment for each observation.}
    \item{\code{control}}{The control parameters used.}
    \item{\code{terms}}{Metadata including covariate names, data dimensions,
      and the values of \code{r_a} and \code{r_b}.}
    \item{\code{method}}{The splitting method used.}
  }
}
\description{
Builds a binary tree for clustering time series data based on covariates,
using a group factor model framework. The splitting criterion evaluates
whether child nodes exhibit distinct factor structures.
}
\details{
The FACT algorithm clusters time series by recursively partitioning them
based on their underlying factor structures. At each node, the method:
\enumerate{
  \item Searches for the optimal split across all covariates and candidate points.
  \item Computes a test statistic based on the overlap of factor spaces
    between the two child nodes.
  \item Decides whether to split using either a threshold rule or permutation test.
}
}
\examples{
\donttest{
data <- gendata(seed = 123, T = 200, N = c(50, 50, 50, 50))
tree1 <- FACT(data$X, data$Y, r_a = 8, r_b = 4, method = "threshold")
print(tree1)
}

}
\references{
Hu, J., Li, T., Luo, Z., & Wang, X. Factor-Augmented Clustering Tree for Time Series.
}
\seealso{
\code{\link{COR}} for correlation-based clustering,
\code{\link{gendata}} for generating synthetic data,
\code{\link{print.FACT}} and \code{\link{plot.FACT}} for visualization.
}
