% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_gnn.R
\name{train_gnn}
\alias{train_gnn}
\title{Train and Evaluate the Gated Neural Network (robust splits + safe ROC)}
\usage{
train_gnn(
  prepared_data,
  hyper_grid,
  num_repeats = 20,
  epochs = 300,
  output_dir = tempdir(),
  run_tuning = TRUE,
  best_params = NULL,
  save_outputs = FALSE,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{prepared_data}{List from prepare_data(): X, y, group, feature_names, subject_ids}

\item{hyper_grid}{data.frame with columns: lr, hidden_dim, dropout_rate, lambda, temperature}

\item{num_repeats}{Integer, repeated train/test splits per combo & final run}

\item{epochs}{Integer, epochs per run}

\item{output_dir}{Directory to write csv/rds (defaults to tempdir())}

\item{run_tuning}{Logical, run hyperparameter search}

\item{best_params}{data.frame/list with lr, hidden_dim, dropout_rate, lambda, temperature if run_tuning=FALSE}

\item{save_outputs}{Logical, whether to save outputs to disk (default FALSE)}

\item{seed}{Optional seed for reproducible data splits. Defaults to NULL to respect the current RNG state.}

\item{verbose}{Logical, whether to print progress messages (default FALSE)}
}
\value{
list(final_results, gate_weights, expert_weights, performance_summary, aif360_data, tuning_results)
}
\description{
Train and Evaluate the Gated Neural Network (robust splits + safe ROC)
}
