% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phf_pbp.R
\name{load_phf_team_box}
\alias{load_phf_team_box}
\title{\strong{Load fastRhockey PHF team box scores}}
\usage{
load_phf_team_box(
  seasons = most_recent_phf_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given PHF seasons. (Min: 2011)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_phf_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the team box data table within the database}
}
\value{
Returns a tibble
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  try(load_phf_team_box(2021))
}
}
