% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{fastcpd-class}
\alias{fastcpd-class}
\title{An S4 class to store the output created with \code{\link[=fastcpd]{fastcpd()}}}
\description{
This S4 class stores the output from \code{\link[=fastcpd]{fastcpd()}} and
\link{fastcpd.family}. A fastcpd object consist
of several slots including the call to \code{\link[=fastcpd]{fastcpd()}}, the data used, the
family of the model, the change points, the cost values, the residuals, the
estimated parameters and a boolean indicating whether the model was fitted
with only change points or with change points and parameters, which you can
select using \code{@}.
}
\section{Slots}{

\describe{
\item{\code{call}}{The call of the function.}

\item{\code{data}}{The data passed to the function.}

\item{\code{order}}{The order of the time series model.}

\item{\code{family}}{The family of the model.}

\item{\code{cp_set}}{The set of change points.}

\item{\code{cost_values}}{The cost function values for each segment.}

\item{\code{residuals}}{The residuals of the model with change points.
Used only for built-in families.}

\item{\code{thetas}}{The estimated parameters for each segment. Used only for
built-in families.}

\item{\code{cp_only}}{A boolean indicating whether \code{\link[=fastcpd]{fastcpd()}} was run to return
only the change points or the change points with the estimated parameters
and cost values for each segment.}
}}

