% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.r
\name{extract,GRaster,GVector-method}
\alias{extract,GRaster,GVector-method}
\alias{extract}
\alias{extract,GRaster,data.frame-method}
\alias{extract,GRaster,data.table-method}
\alias{extract,GRaster,matrix-method}
\alias{extract,GRaster,numeric-method}
\alias{extract,GVector,GVector-method}
\alias{extract,GVector,data.frame-method}
\alias{extract,GVector,data.table-method}
\alias{extract,GVector,matrix-method}
\alias{extract,GVector,numeric-method}
\title{Extract values from a GRaster at locations in a points GVector}
\usage{
\S4method{extract}{GRaster,GVector}(
  x,
  y,
  fun = "mean",
  prob = 0.5,
  overlap = TRUE,
  xy = FALSE,
  cats = TRUE,
  verbose = FALSE,
  ...
)

\S4method{extract}{GRaster,data.frame}(x, y, xy = FALSE, cats = TRUE)

\S4method{extract}{GRaster,data.table}(x, y, xy = FALSE, cats = TRUE)

\S4method{extract}{GRaster,matrix}(x, y, xy = FALSE, cats = TRUE)

\S4method{extract}{GRaster,numeric}(x, y, xy = FALSE, cats = TRUE)

\S4method{extract}{GVector,GVector}(x, y, xy = FALSE, verbose = TRUE)

\S4method{extract}{GVector,data.frame}(x, y, xy = FALSE, verbose = TRUE)

\S4method{extract}{GVector,data.table}(x, y, xy = FALSE, verbose = TRUE)

\S4method{extract}{GVector,matrix}(x, y, xy = FALSE, verbose = TRUE)

\S4method{extract}{GVector,numeric}(x, y, xy = FALSE)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector}.}

\item{y}{A \code{GVector}, \emph{or} a \code{data.frame} or \code{matrix} where the first two columns represent longitude and latitude (in that order), \emph{or} a two-element numeric vector where the first column represents longitude and the second latitude. Values of \code{x} will be extracted from the points in \code{y}. \code{GVector}s can be of types points, lines, or polygons.}

\item{fun}{Character vector: Name(s) of function(s) to apply to values. This is used when \code{x} is a \code{GRaster} and \code{y} is a lines or polygons \code{GVector}. The method(s) specified by \code{fun} will be applied to all cell values that overlap with each geometry (i.e., individual cell values will not be returned). Valid functions include:
\itemize{
\item \code{"countNonNA"}: Number of overlapping cells.
\item \code{"countNA"}: Number of overlapping \code{NA} cells.
\item \code{"mean"}: Average.
\item \code{"min"}: Minimum.
\item \code{"max"}: Minimum.
\item \code{"sum"}: Sum.
\item \code{"range"}: Maximum - minimum.
\item \code{"sd"}: Sample standard deviation (same as \code{\link[stats:sd]{stats::sd()}}).
\item \code{"sdpop"}: Population standard deviation.
\item \code{"var"}: Sample variance (same as \code{\link[stats:cor]{stats::var()}}).
\item \code{"varpop"}: Population variance.
\item \code{"cv"}: Coefficient of variation.
\item \code{"cvpop"}: Population coefficient of variation.
\item \code{"median"}: Median.
\item \code{"quantile"}: Quantile; you can specify the quantile using the \code{prob} argument.
}}

\item{prob}{Numeric in the range from 0 to 1: Quantile which to calculate. The value of \code{prob} will be rounded to the nearest hundredth.}

\item{overlap}{Logical: If \code{TRUE} (default), and \code{y} is a lines or polygons \code{GVector}, then account for potential overlap of geometries when extracting. This can be slow, so if you are sure geometries do not overlap, you can change this to \code{FALSE}. This argument is ignored if \code{y} is a points \code{GVector}.}

\item{xy}{Logical: If \code{TRUE} and \code{y} represents points, also return the coordinates of each point. Default is \code{FALSE.}}

\item{cats}{Logical (extracting from a raster): If \code{TRUE} (default) and \code{x} is a categorical \code{GRaster}, then return the category labels instead of the values.}

\item{verbose}{Logical: If \code{TRUE}, display progress (will only function when extracting from points on a \code{GRaster} when the number of \code{GRaster}s is large, or when extracting using a "points" \code{GVector} with lots of points).}

\item{...}{Arguments to pass to \code{\link[=project]{project()}}. This is used only if extracting from a \code{GRaster} at locations specified by a \code{GVector}, and they have a different coordinate reference system. In this case, users should specify the \code{wrap} argument to \code{\link[=project]{project()}}.}
}
\value{
A \code{data.frame} or \code{data.table}.
}
\description{
\code{extract()} obtains the values of a \code{GRaster} or \code{GVector} associated with the locations of a set of points. The output depends on the input:
\itemize{
\item \strong{Case #1: \code{x} is a numeric or integer \code{GRaster} and \code{y} is a points \code{GVector}}: Returns values of cells that have points. If \code{xy} is \code{TRUE}, also returns the coordinates of the points.
\item \strong{Case #2: \code{x} is a categorical (factor) \code{GRaster} and \code{y} is a points \code{GVector}}: Same as case #1, but if \code{cats} is \code{TRUE}, returns category labels of cells that have points. If \code{xy} is \code{TRUE}, also returns the coordinates of the points.
\item \strong{Case #3: \code{x} is a categorical \code{GRaster} and \code{y} is a lines or polygons \code{GVector}}: Returns a summary (e.g., mean, standard deviation, etc.) of all cells that overlap the line(s) or polygon(s).
\item \strong{Case #4: \code{x} is a \code{GVector} and \code{y} is a points \code{GVector}}: Returns the data table row associated each point. If \code{xy} is \code{TRUE}, also returns the coordinates of the points.
Note that whenever a points \code{GVector} is allowed for \code{y}, a \code{data.frame}, \code{data.table}, \code{matrix}, or \code{numeric} values representing points can be used instead.
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data: elevation raster and points vector
madElev <- fastData("madElev") # raster
madCover <- fastData("madCover") # categorical raster
madDypsis <- fastData("madDypsis") # points vector
madRivers <- fastData("madRivers") # lines vector
madCoast4 <- fastData("madCoast4") # polygons vector

# Convert to fasterRaster formats:
elev <- fast(madElev) # raster
cover <- fast(madCover) # categorical raster
dypsis <- fast(madDypsis) # points vector
rivers <- fast(madRivers) # lines vector
coast <- fast(madCoast4) # polygons vector

# Get values of elevation at points where Dypsis species are located:
extract(elev, dypsis, xy = TRUE)

# Extract from categorical raster at points:
categories <- extract(cover, dypsis)
categoryValues <- extract(cover, dypsis, cats = FALSE)
categories
categoryValues

# Extract and summarize values on a raster across polygons:
extract(elev, coast, fun = c("sum", "mean", "countNonNA"), overlap = FALSE)

# Extract and summarize values on a raster across lines:
extract(elev, rivers, fun = c("sum", "mean", "countNonNA"), overlap = FALSE)

# Extract from a polygons vector at a points vector:
polysFromPoints <- extract(coast, dypsis, xy = TRUE)
head(polysFromPoints) # first 3 are outside polygons vector, next 3 are inside

}
}
\seealso{
\code{\link[terra:extract]{terra::extract()}}, and modules \code{r.what} and \code{v.what} in \strong{GRASS}
}
