% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_pos}
\alias{simulate_pos}
\title{Simulate several points of stability}
\usage{
simulate_pos(
  x_pop,
  y_pop,
  n_studies,
  sample_size_min,
  sample_size_max,
  replace,
  lower_limit,
  upper_limit,
  progress
)
}
\arguments{
\item{x_pop}{First vector of population.}

\item{y_pop}{Second vector of population.}

\item{n_studies}{How many studies to conduct.}

\item{sample_size_min}{Minimum sample size to start in corridor of
stability.}

\item{sample_size_max}{How many participants to draw at maximum.}

\item{replace}{Whether drawing samples is with replacement or not.}

\item{lower_limit}{Lower limit of corridor of stability.}

\item{upper_limit}{Upper limit of corridor of stability.}

\item{progress}{Should progress bar be displayed? Boolean, default is FALSE.}
}
\value{
Vector of sample sizes at which corridor of stability was reached.
}
\description{
Runs several simulations and returns the points of stability, which can then
be further processed to calculate the critical point of stability. This
function should only be used if you need the specific points of stability.
For instance, if you want to study the method in more detail and the higher
level functions are not sufficient.
}
\details{
If you just want to calculate a quantile of the distribution, use the main
function of the package \code{\link[=find_critical_pos]{find_critical_pos()}}).
}
\examples{
# set up a population
pop <- fastpos::create_pop(rho = 0.5, size = 1e6)
# create a distribution of points of stability
pos <- simulate_pos(x_pop = pop[,1], y_pop = pop[,2], n_studies = 100,
                    sample_size_min = 20, sample_size_max = 1e3,
                    replace = TRUE, lower_limit = 0.4, upper_limit = 0.6,
                    progress = TRUE)
# calculate quantiles or any other parameter of the distribution
quantile(pos, c(.8, .9, .95))
}
