% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf1_tbl.R
\name{tbl}
\alias{tbl}
\title{tbl}
\usage{
tbl(
  obj,
  title = "",
  format = NULL,
  code = FALSE,
  tabs = FALSE,
  full_page = TRUE,
  ...
)
}
\arguments{
\item{obj}{Object used to create the table.

\code{data.frame}, \code{list} or environment
(or object coercible by \code{as.data.frame} to a \code{data.frame})}

\item{title}{Title for the table, write in string format}

\item{format}{Format of table, write in string format. Possible values are \code{"latex"}, "\code{html}".}

\item{code}{If you want the table code to appear in the console, put \code{code = TRUE}, you can combine with \code{format}.}

\item{tabs}{If you want a row separator inside table, put \code{tabs = FALSE}.}

\item{full_page}{If you want the table not to take up the full width of the page, put \code{full_page = FALSE}.}

\item{...}{Other arguments}
}
\value{
Your object of input in the format of a knitr_kable
}
\description{
This is the primary function of fastrep, with her you can make tables in HTML or LaTeX format,
the main idea is to provide minimal parameters to create their own table,
so you necessarily only need to provide a data.frame
}
\note{
Remember that by default the format is \code{"html"}

The default of \code{code} is \code{FALSE}
The default of \code{tabs} is \code{TRUE}
The default of \code{full_page} is \code{TRUE}

The value of  \code{format}  will be automatically determined if the function is called within a knitr document
}
\examples{
iris \%>\%
  dplyr::group_by(Species) \%>\%
  dplyr::summarise(mean = mean(Sepal.Length)) \%>\%
  fastrep::tbl("THIS FUNCTION IS SO INCREDIBLE!")

mtcars |>
  dplyr::group_by(carb) |>
  dplyr::summarise(sd = sd(wt)) |>
  fastrep::tbl()

}
