% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_attr.r
\name{are_named}
\alias{are_named}
\alias{are_named2}
\alias{have_names}
\title{Are objects named?}
\usage{
are_named(..., .all = FALSE)

are_named2(..., .all = FALSE)

have_names(..., .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.all}{Whether to return if all arguments are TRUE.}
}
\value{
\code{are_named()} and \code{are_named2()} return a named logical,
or unnamed boolean if \code{.all} is \code{TRUE}. \code{have_names()} is vectorised
and returns a list of logical vectors whhere each is as long as the
input object. When \code{.all} is \code{TRUE} for \code{have_names()}, all logical
vectors are collapsed and a boolean is returned.
}
\description{
Wrappers around \link[rlang:rlang-package]{rlang} predicates that allow multiple
objects to be passed. The following documentation is adapted
from the rlang \link[rlang:is_named]{documentation}:
\itemize{
\item \code{are_named()} is a scalar predicate that checks that objects in \code{...}
have a \code{names} attribute and that none of the names are missing or empty
(\code{NA} or \code{""}).
\item \code{are_named2()} is like \code{are_named()} but always returns \code{TRUE} for
empty vectors, even those that don't have a \code{names} attribute.
In other words, it tests for the property that each element of a
vector is named. \code{are_named2()} composes well with \code{names2()}
whereas \code{are_named()} composes with \code{names()}.
\item \code{have_names()} is a vectorised variant.
}
}
\examples{
# are_named() is a scalar predicate about the whole vector of names:
x <- c(a = 1, b = 2)
are_named(x, c(a = 1, 2))
are_named(x, c(a = 1, 2), .all = TRUE)

# Unlike are_named2(), are_named() returns `FALSE` for empty vectors
# that don't have a `names` attribute.
are_named(list(), vector())
are_named2(list(), vector())

# have_names() is vectorised
y <- c(a = 1, 2)
have_names(x, y, c(a = 1, 2, 3))
have_names(x, y, c(a = 1, 2, 3), .all = TRUE)

# Empty and missing names are treated as invalid:
invalid <- setNames(letters[1:5], letters[1:5])
names(invalid)[1] <- ""
names(invalid)[3] <- NA

are_named(invalid)
have_names(invalid)

# A data frame normally has valid, unique names
# but a matrix usually doesn't because the names
# are stored in a different attribute.
mat <- matrix(1:4, 2)
colnames(mat) <- c("a", "b")
are_named(mtcars, mat)
have_names(mtcars, mat)
}
\seealso{
\link{are-bare-type-predicates} \link[rlang:is_named]{rlang::is_named}
}
