% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_types.r
\name{are_true}
\alias{are_true}
\alias{are_false}
\title{Are objects TRUE or FALSE?}
\usage{
are_true(..., .all = FALSE)

are_false(..., .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.all}{Whether to return if all arguments are TRUE.}
}
\value{
Named logical, or unnamed boolean if \code{.all} is \code{TRUE}.
}
\description{
Test if any number of inputs are TRUE or FALSE.
Inputs are passed to \link{isTRUE} or \link{isFALSE}.
}
\examples{
x <- TRUE
y <- 1
z <- mean

are_true(x, y, z, TRUE, 0)

are_true(x, y, z, TRUE, 0, .all = TRUE)

are_false(x, y, z, TRUE, 0)

are_false(x, y, z, TRUE, 0, .all = TRUE)
}
\seealso{
\link{isTRUE} \link{isFALSE}
}
