% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing_and_conversion.R
\name{expanded_to_ROI}
\alias{expanded_to_ROI}
\title{Parse a long format metabolic model to an ROI model}
\usage{
expanded_to_ROI(reactions_expanded)
}
\arguments{
\item{reactions_expanded}{A list of data frames as output by \code{reactiontbl_to_expanded}}
}
\value{
A list suitable for input to ROI.
}
\description{
This parses the long format produced by \code{reactiontbl_to_expanded} to an ROI model.
}
\details{
To solve models using ROI, you will need a solver plugin for ROI. Probably the easiest one to install is ROI.plugin.glpk.
To install this in Linux, run \code{sudo apt-get install libglpk-dev} in a terminal, and then run \code{install.packages('ROI.plugin.glpk')} in R.

The \code{reaction_table} must have columns:
\itemize{
 \item \code{abbreviation},
 \item \code{equation},
 \item \code{uppbnd},
 \item \code{lowbnd}, and
 \item \code{obj_coef}.
}
}
\examples{

\dontrun{
data(ecoli_core)
library(dplyr)
try(library(ROI.plugin.ecos)) # make a solver available to ROI

roi_model <- ecoli_core \%>\%
  reactiontbl_to_expanded \%>\%
  expanded_to_ROI
  
if(length(ROI::ROI_applicable_solvers(roi_model))>=1){
  roi_result <- ROI::ROI_solve(roi_model)
  
  ecoli_core_with_flux <- ecoli_core \%>\%
    mutate(flux = roi_result[['solution']])
}
}
}
\seealso{
Other parsing_and_conversion: 
\code{\link{expanded_to_glpk}()},
\code{\link{expanded_to_gurobi}()},
\code{\link{reactiontbl_to_expanded}()},
\code{\link{reactiontbl_to_gurobi}()}
}
\concept{parsing_and_conversion}
