% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolite_utilities.R
\name{recompose_metabolites}
\alias{recompose_metabolites}
\title{Merge metabolite stub and compartment to form an id}
\usage{
recompose_metabolites(
  expanded_metabolites,
  before_signifier = "_",
  after_signifier = ""
)
}
\arguments{
\item{expanded_metabolites}{a metabolite table as created by \code{\link{decompose_metabolites}}}

\item{before_signifier}{a string that is inserted before the compartment identifier}

\item{after_signifier}{a string that is inserted after the compartment identifier}
}
\value{
A merged metabolite table with one column, \code{met}
}
\description{
Merge metabolite stub and compartment to form an id
}
\examples{
data(ecoli_core)

mod <- reactiontbl_to_expanded(ecoli_core)

decompose_metabolites(mod$mets)

recompose_metabolites(decompose_metabolites(mod$mets))
}
