% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{fit_ARHp_FPCA}
\alias{fit_ARHp_FPCA}
\title{Fit an ARH(p) to a given functional time series}
\usage{
fit_ARHp_FPCA(y, v, p, n_harm, show_varprop = T)
}
\arguments{
\item{y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{v}{Numeric vector that contains the 
discretization points of the curves.}

\item{p}{Numeric value specifying the order 
of the functional autoregressive 
model to be fitted.}

\item{n_harm}{Numeric value specifying the number
of functional principal components to be used when fitting
the \eqn{ARH(p)} model.}

\item{show_varprop}{Logical. If \code{show_varprop = TRUE},
a plot of the proportion of variance explained by the first
\code{n_harm} functional principal components will be shown.
By default \code{show_varprop = TRUE}.}
}
\description{
Fit an \eqn{ARH(p)} model to a given functional
time series. The fitted model is based on the model proposed
in (Aue et al, 2015), first decomposing the original
functional observations into a vector time series of \code{n_harm}
FPCA scores, and then fitting a vector autoregressive
model of order \eqn{p} (\eqn{VAR(p)}) to the time series
of the scores. Once fitted, the Karhunen-Loève expansion
is used to re-transform the fitted values into functional
observations.
}
\examples{
# Example 1

# Simulate an ARH(1) process
N <- 250
dv <- 20
v <- seq(from = 0, to = 1, length.out = 20)

phi <- 1.3 * ((v) \%*\% t(v))

persp(v,v,phi, 
      ticktype = "detailed", 
      main = "Integral operator")

set.seed(3)
white_noise <-  simulate_iid_brownian_bridge(N, v = v)

y <- matrix(nrow = N, ncol = dv)
y[1,] <- white_noise[1,]
for(jj in 2:N){
    y[jj,] <- white_noise[jj,];
    
    y[jj,]=y[jj,]+integral_operator(operator_kernel = phi,
                                    v = v,
                                    curve = y[jj-1,])
}

# Fit an ARH(1) model
mod <- fit_ARHp_FPCA(y = y,
                     v = v,
                     p = 1,
                     n_harm = 5)

# Plot results
plot(v, y[50,], type = "l", lty = 1, ylab = "")
lines(v, mod$y_est[50,], col = "red")
legend("bottomleft", legend = c("real","est"),
       lty = 1, col = c(1,2))

}
\references{
Aue, A., Norinho, D. D., Hormann, S. (2015).
\emph{On the Prediction of Stationary Functional 
Time Series}
Journal of the American Statistical Association, 
110, 378--392. \url{https://doi.org/10.1080/01621459.2014.909317}
}
