% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{felt_add_library_layer_group}
\alias{felt_add_library_layer_group}
\title{Add layer group to library}
\usage{
felt_add_library_layer_group(map_id, layer_group_id, name = NULL, clean = TRUE)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{layer_group_id}{character, layer group identifier from url, from \code{felt_get_map()}.}

\item{name}{character, name to save the layer group under. Optional.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} if \code{clean = TRUE}, otherwise a list
}
\description{
Add layer group to library
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_add_library_layer_group(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA',
                            layer_group_id = 'rHxyTef7S9CO8W7n1PvBVwC',
                            name = paste0('Test layer group ', Sys.time()))
\dontshow{\}) # examplesIf}
}
