% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodIF.R
\name{invisiblefence}
\alias{invisiblefence}
\title{Invisible Fence model selection}
\usage{
invisiblefence(mf, f, d, lf, bs)
}
\arguments{
\item{mf}{Call function, for example: default calls: function(m, b) eblupFH(formula = m, vardir = D, data = b, method = "FH")}

\item{f}{Full model}

\item{d}{Dimension number}

\item{lf}{Measures lack of fit using function(res) -res$fit$goodness[1]}

\item{bs}{Bootstrap}
}
\value{
\item{full}{list the full model}
\item{B}{list the number of bootstrap samples that have been used}
\item{freq}{list the coverage probabilities of the selected model for each dimension}
\item{size}{list the number of variables in the parsimonious model}
\item{term}{list variables included in the full model}
\item{model}{list the variables selected in-the-order in the parsimonious model}
 @note The current Invisible Fence focuses on variable selection. The current routine is applicable to the case in which
 the subtractive measure is the absolute value of the coefficients, p-value, t-value.
 However, the method can be extended to other subtractive measures.  See Jiang et. al (2011) for more details.
}
\description{
Invisible Fence model selection
}
\details{
This method (Jiang et. al, 2011) is motivated by computational expensive in complex and high dimensional problem.
The idea of the method--there is the best model in each dimension (in model space).  The boostrapping determines the coverage
probability of the selected model in each dimensions. The parsimonious model is the selected model with the highest coverage probabily
(except the one for the full model, always probability of 1.)
}
\examples{
\dontrun{
data("X.lmer")
data = data.frame(X.lmer)
beta = matrix(c(0, 1, 1, 1, 1, 0, 0.1, 0.05, 0.25, 0), ncol = 1)
set.seed(1234)
alpha = rep(rnorm(100), each = 3)
mu = alpha + as.matrix(data[,-1]) \%*\% beta
data$id = as.factor(data$id)
data$y = mu + rnorm(300)
raw = "y ~ (1|id)+I.col.2+I.col.3a+I.col.3b"
for (i in 5:10) {
    raw = paste0(raw, "+V", i)
}
full = as.formula(raw)
obj1.lmer = IF.lmer(full = full, data = data, B = 100, method="conditional",lftype = "abscoef")
obj1.lmer$model$coefficients
obj2.lmer = IF.lmer(full = full, data = data, B = 100, method="conditional",lftype = "tvalue")
obj2.lmer$model$coefficients
obj1.lm = IF.lmer(full = full, data = data, B = 100, method="marginal", lftype = "abscoef")
obj1.lm$model$coefficients
obj2.lm = IF.lmer(full = full, data = data, B = 100, method="marginal", lftype = "tvalue")
obj2.lm$model$coefficients
}
}
\references{
\itemize{
 \item{Jiang J., Rao J.S., Gu Z., Nguyen T. (2008),  Fence Methods for Mixed Model Selection. The Annals of Statistics, 36(4): 1669-1692}
 \item{Jiming Jiang, Thuan Nguyen and J. Sunil Rao (2011), Invisible fence methods and the identification of differentially expressed gene sets. Statistics and Its Interface, Volume 4, 403-415.}
}
}
\author{
Jiming Jiang  Jianyang Zhao  J. Sunil Rao  Thuan Nguyen
}
