% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetwfe.R
\name{fetwfeWithSimulatedData}
\alias{fetwfeWithSimulatedData}
\title{Run FETWFE on Simulated Data}
\usage{
fetwfeWithSimulatedData(
  simulated_obj,
  lambda.max = NA,
  lambda.min = NA,
  nlambda = 100,
  q = 0.5,
  verbose = FALSE,
  alpha = 0.05,
  add_ridge = FALSE
)
}
\arguments{
\item{simulated_obj}{An object of class \code{"FETWFE_simulated"} containing the simulated panel
data and design matrix.}

\item{lambda.max}{(Optional.) Numeric. A penalty parameter \code{lambda} will be
selected over a grid search by BIC in order to select a single model. The
largest \code{lambda} in the grid will be \code{lambda.max}. If no \code{lambda.max} is
provided, one will be selected automatically. For \code{lambda <= 1}, the model
will be sparse, and ideally all of the following are true at once: the
smallest model (the one corresponding to \code{lambda.max}) selects close to 0
features, the largest model (the one corresponding to \code{lambda.min}) selects
close to \code{p} features, \code{nlambda} is large enough so that models are
considered at every feasible model size, and \code{nlambda} is small enough so
that the computation doesn't become infeasible. You may
want to manually tweak \code{lambda.max}, \code{lambda.min}, and \code{nlambda} to try
to achieve these goals, particularly if the selected model size is very
close to the model corresponding to \code{lambda.max} or \code{lambda.min}, which could
indicate that the range of \code{lambda} values was too narrow. You can use the
function outputs \code{lambda.max_model_size}, \code{lambda.min_model_size}, and
\code{lambda_star_model_size} to try to assess this. Default is NA.}

\item{lambda.min}{(Optional.) Numeric. The smallest \code{lambda} penalty
parameter that will be considered. See the description of \code{lambda.max} for
details. Default is NA.}

\item{nlambda}{(Optional.) Integer. The total number of \code{lambda} penalty
parameters that will be considered. See the description of \code{lambda.max} for
details. Default is 100.}

\item{q}{(Optional.) Numeric; determines what \code{L_q} penalty is used for the
fusion regularization. \code{q} = 1 is the lasso, and for 0 < \code{q} < 1, it is
possible to get standard errors and confidence intervals. \code{q} = 2 is ridge
regression. See Faletto (2025) for details. Default is 0.5.}

\item{verbose}{Logical; if TRUE, more details on the progress of the function will
be printed as the function executes. Default is FALSE.}

\item{alpha}{Numeric; function will calculate (1 - \code{alpha}) confidence intervals
for the cohort average treatment effects that will be returned in \code{catt_df}.}

\item{add_ridge}{(Optional.) Logical; if TRUE, adds a small amount of ridge
regularization to the (untransformed) coefficients to stabilize estimation.
Default is FALSE.}
}
\value{
An object of class \code{fetwfe} containing the following elements:
\item{att_hat}{The estimated overall average treatment effect for a randomly selected treated unit.}
\item{att_se}{If \code{q < 1}, a standard error for the ATT. If \code{indep_counts} was provided, this standard error is asymptotically exact; if not, it is asymptotically conservative. If \code{q >= 1}, this will be NA.}
\item{catt_hats}{A named vector containing the estimated average treatment effects for each cohort.}
\item{catt_ses}{If \code{q < 1}, a named vector containing the (asymptotically exact, non-conservative) standard errors for the estimated average treatment effects within each cohort.}
\item{cohort_probs}{A vector of the estimated probabilities of being in each cohort conditional on being treated, which was used in calculating \code{att_hat}. If \code{indep_counts} was provided, \code{cohort_probs} was calculated from that; otherwise, it was calculated from the counts of units in each treated cohort in \code{pdata}.}
\item{catt_df}{A dataframe displaying the cohort names, average treatment effects, standard errors, and \code{1 - alpha} confidence interval bounds.}
\item{beta_hat}{The full vector of estimated coefficients.}
\item{treat_inds}{The indices of \code{beta_hat} corresponding to the treatment effects for each cohort at each time.}
\item{treat_int_inds}{The indices of \code{beta_hat} corresponding to the interactions between the treatment effects for each cohort at each time and the covariates.}
\item{sig_eps_sq}{Either the provided \code{sig_eps_sq} or the estimated one, if a value wasn't provided.}
\item{sig_eps_c_sq}{Either the provided \code{sig_eps_c_sq} or the estimated one, if a value wasn't provided.}
\item{lambda.max}{Either the provided \code{lambda.max} or the one that was used, if a value wasn't provided. (This is returned to help with getting a reasonable range of \code{lambda} values for grid search.)}
\item{lambda.max_model_size}{The size of the selected model corresponding to \code{lambda.max} (for \code{q <= 1}, this will be the smallest model size). As mentioned above, for \code{q <= 1} ideally this value is close to 0.}
\item{lambda.min}{Either the provided \code{lambda.min} or the one that was used, if a value wasn't provided.}
\item{lambda.min_model_size}{The size of the selected model corresponding to \code{lambda.min} (for \code{q <= 1}, this will be the largest model size). As mentioned above, for \code{q <= 1} ideally this value is close to \code{p}.}
\item{lambda_star}{The value of \code{lambda} chosen by BIC. If this value is close to \code{lambda.min} or \code{lambda.max}, that could suggest that the range of \code{lambda} values should be expanded.}
\item{lambda_star_model_size}{The size of the model that was selected. If this value is close to \code{lambda.max_model_size} or \code{lambda.min_model_size}, that could suggest that the range of \code{lambda} values should be expanded.}
\item{N}{The final number of units that were in the data set used for estimation (after any units may have been removed because they were treated in the first time period).}
\item{T}{The number of time periods in the final data set.}
\item{R}{The final number of treated cohorts that appear in the final data set.}
\item{d}{The final number of covariates that appear in the final data set (after any covariates may have been removed because they contained missing values or all contained the same value for every unit).}
\item{p}{The final number of columns in the full set of covariates used to estimate the model.}
\item{alpha}{The alpha level used for confidence intervals.}
\item{internal}{A list containing internal outputs that are typically not needed for interpretation:
\describe{
\item{X_ints}{The design matrix created containing all interactions, time and cohort dummies, etc.}
\item{y}{The vector of responses, containing \code{nrow(X_ints)} entries.}
\item{X_final}{The design matrix after applying the change in coordinates to fit the model and also multiplying on the left by the square root inverse of the estimated covariance matrix for each unit.}
\item{y_final}{The final response after multiplying on the left by the square root inverse of the estimated covariance matrix for each unit.}
\item{calc_ses}{Logical indicating whether standard errors were calculated.}
}
}

The object has methods for \code{print()}, \code{summary()}, and \code{coef()}. By default, \code{print()} and \code{summary()} only show the essential outputs. To see internal details, use \code{print(x, show_internal = TRUE)} or \code{summary(x, show_internal = TRUE)}. The \code{coef()} method returns the vector of estimated coefficients (\code{beta_hat}).
}
\description{
This function runs the fused extended two-way fixed effects estimator (\code{fetwfe()}) on
simulated data. It is simply a wrapper for \code{fetwfe()}: it accepts an object of class
\code{"FETWFE_simulated"} (produced by \code{simulateData()}) and unpacks the necessary
components to pass to \code{fetwfe()}. So the outputs match \code{fetwfe()}, and the needed inputs
match their counterparts in \code{fetwfe()}.
}
\examples{
\dontrun{
  # Generate coefficients
  coefs <- genCoefs(R = 5, T = 30, d = 12, density = 0.1, eff_size = 2, seed = 123)

  # Simulate data using the coefficients
  sim_data <- simulateData(coefs, N = 120, sig_eps_sq = 5, sig_eps_c_sq = 5)

  result <- fetwfeWithSimulatedData(sim_data)
}

}
