% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\docType{class}
\name{stack-class}
\alias{stack-class}
\alias{show,stack-method}
\alias{createS}
\alias{initS}
\alias{push,stack-method}
\alias{mpush}
\alias{mpush,stack-method}
\alias{isEmpty,stack-method}
\alias{top,stack-method}
\alias{pop,stack-method}
\title{Stack Class}
\usage{
\S4method{show}{stack}(object)

createS(filename)

initS(filename)

\S4method{push}{stack}(db, val, ...)

mpush(db, vals, ...)

\S4method{mpush}{stack}(db, vals, ...)

\S4method{isEmpty}{stack}(db, ...)

\S4method{top}{stack}(db, ...)

\S4method{pop}{stack}(db, ...)
}
\arguments{
\item{object}{a stack object}

\item{filename}{name of file where stack is stored}

\item{db}{a stack object}

\item{val}{an R object to be added to the stack}

\item{...}{arguments passed to other methods}

\item{vals}{a list of R objects}
}
\value{
a stack object
}
\description{
A stack implementation using a \code{filehash} database
}
\details{
Objects can be created by calls of the form \code{new("stack", ...)} or by calling \code{createS}.  Existing queues can be initialized with \code{initS}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(stack)}: Print a stack object.

\item \code{push(stack)}: Push an object on to the stack

\item \code{mpush(stack)}: Push a list of R objects on to the stack

\item \code{isEmpty(stack)}: Indicate whether the stack is empty or not

\item \code{top(stack)}: Return the top element of the stack

\item \code{pop(stack)}: Return the top element of the stack and remove that element from the stack

}}
\section{Functions}{
\itemize{
\item \code{createS()}: Create a filehash Stack

\item \code{initS()}: Initialize and existing filehash stack

\item \code{mpush()}: Push multiple R objects on to a stack

}}
\section{Slots}{

\describe{
\item{\code{stack}}{Object of class \code{"filehashDB1"}}

\item{\code{name}}{Object of class \code{"character"}: the name of the stack (default is the file name in which the stack data are stored)}
}}

