% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desirability2.R
\name{show_best_desirability_prop}
\alias{show_best_desirability_prop}
\title{Show best desirability scores, based on proportion of predictors \emph{(plural)}}
\usage{
show_best_desirability_prop(x, ..., prop_terms = 1)
}
\arguments{
\item{x}{A tibble or data frame returned by \code{\link[=fill_safe_values]{fill_safe_values()}}.}

\item{...}{One or more desirability selectors to configure the optimization.}

\item{prop_terms}{A numeric value specifying the proportion
of predictors to consider.}
}
\value{
A tibble with \code{prop_terms}
proportion of rows. When showing the results,
the metrics are presented in "wide format" (one column per metric) and there
are new columns for the corresponding desirability values (each starts with
\code{.d_}).
}
\description{
Analogous to, and adapted from \code{\link[desirability2:show_best_desirability]{desirability2::show_best_desirability()}} that can
simultaneously optimize multiple scores using desirability functions.
See \code{\link[=show_best_score_prop]{show_best_score_prop()}} for \emph{singular} filtering method.
}
\details{
Desirability functions might help when selecting the best model
based on more than one performance metric. The user creates a desirability
function to map values of a metric to a \verb{[0, 1]} range where 1.0 is most
desirable and zero is unacceptable. After constructing these for the metric
of interest, the overall desirability is computed using the geometric mean
of the individual desirabilities.

The verbs that can be used in \code{...} (and their arguments) are:
\itemize{
\item \code{maximize()} when larger values are better, such as the area under the ROC
score.
\item \code{minimize()} for metrics such as RMSE or the Brier score.
\item \code{target()} for cases when a specific value of the metric is important.
\item \code{constrain()} is used when there is a range of values that are equally
desirable.
}
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(desirability2)
library(dplyr)

# Remove outcome
ames_scores_results <- ames_scores_results |>
  dplyr::select(-outcome)
ames_scores_results

show_best_desirability_prop(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1)
)

show_best_desirability_prop(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf)
)

show_best_desirability_prop(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf),
  maximize(infogain)
)

show_best_desirability_prop(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf),
  maximize(infogain),
  prop_terms = 0.2
)

show_best_desirability_prop(
  ames_scores_results,
  target(cor_pearson, low = 0.2, target = 0.255, high = 0.9)
)

show_best_desirability_prop(
  ames_scores_results,
  constrain(cor_pearson, low = 0.2, high = 1)
)
\dontshow{\}) # examplesIf}
}
